/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.model;

import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public enum CryptoAlgorithm {
    AES_GCM_NOPADDING_128("AES", "AES_128", "AES/GCM/NoPadding", 16, 12, 16, 16, 1, true),
    AES_GCM_NOPADDING_256("AES", "AES_256", "AES/GCM/NoPadding", 32, 12, 16, 16, 2, true),
    AES_CBC_NOPADDING_128("AES", "AES_128", "AES/CBC/NoPadding", 16, 16, 0, 16, 3, false),
    AES_CBC_NOPADDING_256("AES", "AES_256", "AES/CBC/NoPadding", 32, 16, 0, 16, 4, false),
    AES_CBC_PKCS5_128("AES", "AES_128", "AES/CBC/PKCS5Padding", 16, 16, 0, 16, 5, false),
    AES_CBC_PKCS5_256("AES", "AES_256", "AES/CBC/PKCS5Padding", 32, 16, 0, 16, 6, false),
    AES_CTR_NOPADDING_128("AES", "AES_128", "AES/CTR/NoPadding", 16, 16, 0, 16, 7, false),
    AES_CTR_NOPADDING_256("AES", "AES_256", "AES/CTR/NoPadding", 32, 16, 0, 16, 8, false),
    SM4_GCM_NOPADDING_128("SM4", "SM4_128", "SM4/GCM/NoPadding", 16, 12, 16, 16, 9, true),
    SM4_CBC_NOPADDING_128("SM4", "SM4_128", "SM4/CBC/NoPadding", 16, 16, 0, 16, 10, false),
    SM4_CBC_PKCS5_128("SM4", "SM4_128", "SM4/CBC/PKCS5Padding", 16, 16, 0, 16, 11, false),
    SM4_CTR_NOPADDING_128("SM4", "SM4_128", "SM4/CTR/NoPadding", 16, 16, 0, 16, 12, false);

    private String keyName;
    private String keySpec;
    private String cryptoName;
    private int keyLen;
    private int ivLen;
    private int tagLen;
    private int blockSize;
    private int value;
    private boolean withAad;

    private CryptoAlgorithm(String keyName, String keySpec, String cryptoName, int keyLen, int ivLen, int tagLen, int blockSize, int value, boolean withAad) {
        this.keyName = keyName;
        this.keySpec = keySpec;
        this.cryptoName = cryptoName;
        this.keyLen = keyLen;
        this.ivLen = ivLen;
        this.tagLen = tagLen;
        this.blockSize = blockSize;
        this.value = value;
        this.withAad = withAad;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getKeySpec() {
        return this.keySpec;
    }

    public String getCryptoName() {
        return this.cryptoName;
    }

    public int getKeyLen() {
        return this.keyLen;
    }

    public int getIvLen() {
        return this.ivLen;
    }

    public int getTagLen() {
        return this.tagLen;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isWithAad() {
        return this.withAad;
    }

    public AlgorithmParameterSpec getSpec(byte[] iv) {
        switch (this) {
            case AES_GCM_NOPADDING_128: 
            case AES_GCM_NOPADDING_256: {
                return new GCMParameterSpec(this.getTagLen() * 8, iv);
            }
        }
        return new IvParameterSpec(iv);
    }

    public void digestAlgorithm(MessageDigest digest) {
        digest.update((byte)this.value);
    }

    public static CryptoAlgorithm getAlgorithm(int value) {
        for (CryptoAlgorithm algorithm : CryptoAlgorithm.values()) {
            if (algorithm.getValue() != value) continue;
            return algorithm;
        }
        return null;
    }
}

