/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.model;

import com.aliyun.encryptionsdk.exception.AliyunException;
import com.aliyun.encryptionsdk.handler.AlgorithmHandler;
import com.aliyun.encryptionsdk.model.CryptoAlgorithm;
import com.aliyun.encryptionsdk.model.EncryptedDataKey;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class CipherHeader {
    private CryptoAlgorithm algorithm;
    private Map<String, String> encryptionContext;
    private byte[] encryptionContextBytes;
    private List<EncryptedDataKey> encryptedDataKeys;
    private byte[] headerIv;
    private byte[] headerAuthTag;

    public CipherHeader(List<EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext, CryptoAlgorithm algorithm) {
        this.encryptedDataKeys = encryptedDataKeys;
        this.encryptionContext = encryptionContext;
        this.encryptionContextBytes = this.serializeContext(encryptionContext);
        this.algorithm = algorithm;
    }

    public CipherHeader(List<EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext, CryptoAlgorithm algorithm, byte[] headerIv, byte[] headerAuthTag) {
        this.encryptedDataKeys = encryptedDataKeys;
        this.encryptionContext = encryptionContext;
        this.encryptionContextBytes = this.serializeContext(encryptionContext);
        this.algorithm = algorithm;
        this.headerIv = headerIv;
        this.headerAuthTag = headerAuthTag;
    }

    public void setHeaderIv(byte[] headerIv) {
        this.headerIv = headerIv;
    }

    public void setAlgorithm(CryptoAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public List<EncryptedDataKey> getEncryptedDataKeys() {
        return this.encryptedDataKeys;
    }

    public Map<String, String> getEncryptionContext() {
        return this.encryptionContext;
    }

    public byte[] getEncryptionContextBytes() {
        return this.encryptionContextBytes;
    }

    public CryptoAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getHeaderIv() {
        return this.headerIv;
    }

    public byte[] getHeaderAuthTag() {
        return this.headerAuthTag;
    }

    public void calculateHeaderAuthTag(AlgorithmHandler handler) {
        byte[] headerFieldsBytes = this.serializeAuthenticatedFields();
        byte[] headerIv = new byte[this.algorithm.getIvLen()];
        SecureRandom random = new SecureRandom();
        random.nextBytes(headerIv);
        byte[] headerAuthTag = handler.cipherData(headerIv, headerFieldsBytes, new byte[0], 0, 0);
        this.headerIv = headerIv;
        this.headerAuthTag = headerAuthTag;
    }

    public byte[] serializeAuthenticatedFields() {
        try {
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(outBytes);
            dataStream.writeInt(this.algorithm.getValue());
            dataStream.writeInt(this.encryptionContext.size());
            dataStream.write(this.encryptionContextBytes);
            dataStream.writeInt(this.encryptedDataKeys.size());
            TreeSet<EncryptedDataKey> set = new TreeSet<EncryptedDataKey>(this.encryptedDataKeys);
            for (EncryptedDataKey dataKey : set) {
                dataStream.write(dataKey.toByteArray());
            }
            dataStream.close();
            return outBytes.toByteArray();
        }
        catch (IOException e) {
            throw new AliyunException("Failed to serialize cipher text headers", e);
        }
    }

    private byte[] serializeContext(Map<String, String> encryptionContext) {
        TreeMap<String, String> map = new TreeMap<String, String>(encryptionContext);
        ByteBuffer result = ByteBuffer.allocate(Short.MAX_VALUE);
        result.order(ByteOrder.BIG_ENDIAN);
        result.putInt(encryptionContext.size());
        try {
            for (Map.Entry<String, String> mapEntry : map.entrySet()) {
                byte[] keyBytes = mapEntry.getKey().getBytes(StandardCharsets.UTF_8);
                result.putInt(keyBytes.length);
                result.put(keyBytes);
                byte[] valueBytes = mapEntry.getValue().getBytes(StandardCharsets.UTF_8);
                result.putInt(valueBytes.length);
                result.put(valueBytes);
            }
        }
        catch (BufferUnderflowException e) {
            throw new AliyunException("encryptionContext must be shorter than 32767", e);
        }
        result.flip();
        byte[] encryptionContextBytes = new byte[result.limit()];
        result.get(encryptionContextBytes);
        return encryptionContextBytes;
    }
}

