/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.encryptionsdk.cache;

import com.aliyun.encryptionsdk.model.DecryptionMaterial;
import com.aliyun.encryptionsdk.model.EncryptionMaterial;

public interface DataKeyCache {
    public EncryptEntry getEncryptEntry(String var1, UsageInfo var2);

    public void putEncryptEntry(String var1, long var2, EncryptionMaterial var4, UsageInfo var5);

    public DecryptEntry getDecryptEntry(String var1);

    public void putDecryptEntry(String var1, long var2, DecryptionMaterial var4);

    public static class UsageInfo {
        private long encryptedBytes;
        private long encryptedMessages;

        public UsageInfo(long encryptedBytes, long encryptedMessages) {
            this.encryptedBytes = encryptedBytes;
            this.encryptedMessages = encryptedMessages;
        }

        public long getEncryptedBytes() {
            return this.encryptedBytes;
        }

        public long getEncryptedMessages() {
            return this.encryptedMessages;
        }

        public UsageInfo add(UsageInfo usageInfo) {
            return new UsageInfo(this.safeAdd(this.encryptedBytes, usageInfo.encryptedBytes), this.safeAdd(this.encryptedMessages, usageInfo.encryptedMessages));
        }

        private long safeAdd(long a, long b) {
            long r = a + b;
            if (a > 0L && b > 0L && r < a) {
                return Long.MAX_VALUE;
            }
            return r;
        }

        public String toString() {
            return "encryptedBytes: " + this.encryptedBytes + " encryptedMessages: " + this.encryptedMessages;
        }
    }

    public static interface DecryptEntry {
        public String getCacheId();

        public DecryptionMaterial getMaterial();

        public void invalid();
    }

    public static interface EncryptEntry {
        public String getCacheId();

        public EncryptionMaterial getMaterial();

        public UsageInfo getUsageInfo();

        public void invalid();
    }
}

