/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.mojo;

import com.alipay.sofa.boot.git.JGitParser;
import com.alipay.sofa.boot.mojo.AbstractExecMojo;
import com.alipay.sofa.boot.vo.GitInfo;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="gen", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenPropertiesMojo
extends AbstractExecMojo {
    private Log log = this.getLog();
    private Properties properties;
    @Parameter(defaultValue="yyyy-MM-dd'T'HH:mm:ssZ")
    private String buildDateFormat;
    @Parameter(defaultValue="${project.basedir}/.git")
    private File dotGitDirectory;
    @Parameter(defaultValue="yyyy-MM-dd'T'HH:mm:ssZ")
    private String commitDateFormat;
    @Parameter(defaultValue="false")
    private boolean ignoreNoGitDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.properties = new Properties();
            this.generateBuildProperties(this.properties);
            this.generateGitProperties(this.properties);
            this.mergeProperties(this.properties, this.project.getProperties());
        }
        catch (MojoFailureException e) {
            this.log.error((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void generateBuildProperties(Properties properties) {
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)"== generate build properties.");
        }
        String now = new SimpleDateFormat(this.buildDateFormat).format(new Date());
        this.put(properties, "build.time", now);
        this.put(properties, "build.version", this.project.getVersion());
    }

    private void generateGitProperties(Properties properties) throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info((CharSequence)"== generate git properties.");
        }
        if (this.dotGitDirectory == null) {
            this.log.info((CharSequence)"dotGitDirectory is null, aborting execution!");
            return;
        }
        this.log.info((CharSequence)("dotGitDirectory " + this.dotGitDirectory.getAbsolutePath()));
        JGitParser parser = new JGitParser();
        GitInfo gitInfo = parser.parse(this.dotGitDirectory, this.log, this.ignoreNoGitDirectory);
        if (gitInfo != null) {
            this.log.info((CharSequence)("find git info: " + gitInfo));
            this.put(properties, "commit.branch", gitInfo.getBranchName());
            this.put(properties, "build.user.name", gitInfo.getBuildUser());
            this.put(properties, "build.user.email", gitInfo.getBuildEmail());
            this.put(properties, "commit.id", gitInfo.getLastCommitId());
            this.put(properties, "commit.id.full", gitInfo.getLastCommitId());
            String commitTime = new SimpleDateFormat(this.commitDateFormat).format(gitInfo.getLastCommitTime());
            this.put(properties, "commit.time", commitTime);
            this.put(properties, "commit.timestamp", gitInfo.getLastCommitTime() + "");
            this.put(properties, "commit.user.name", gitInfo.getLastCommitUser());
            this.put(properties, "commit.user.email", gitInfo.getLastCommitEmail());
        }
    }

    private void mergeProperties(Properties genProperties, Properties targetProperties) {
        this.logProperties(genProperties);
        if (this.properties != null && targetProperties != null) {
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                this.put(targetProperties, entry.getKey(), entry.getValue());
            }
        }
    }
}

