/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.container.service.injection;

import com.alipay.sofa.ark.common.log.ArkLoggerFactory;
import com.alipay.sofa.ark.common.util.ReflectionUtils;
import com.alipay.sofa.ark.exception.ArkRuntimeException;
import com.alipay.sofa.ark.spi.registry.ServiceReference;
import com.alipay.sofa.ark.spi.service.ArkInject;
import com.alipay.sofa.ark.spi.service.injection.InjectionService;
import com.alipay.sofa.ark.spi.service.registry.RegistryService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Field;

@Singleton
public class InjectionServiceImpl
implements InjectionService {
    @Inject
    private RegistryService registryService;

    public void inject(ServiceReference reference) {
        this.inject(reference.getService(), reference.toString());
    }

    public void inject(Object object) {
        this.inject(object, object.getClass().getName());
    }

    private void inject(final Object instance, final String type) {
        ReflectionUtils.doWithFields(instance.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws ArkRuntimeException {
                ArkInject arkInject = field.getAnnotation(ArkInject.class);
                if (arkInject == null) {
                    return;
                }
                Class serviceType = arkInject.interfaceType() == Void.TYPE ? field.getType() : arkInject.interfaceType();
                Object value = InjectionServiceImpl.this.getService(serviceType, arkInject.uniqueId());
                if (value == null) {
                    ArkLoggerFactory.getDefaultLogger().warn(String.format("Inject {field= %s} of {service= %s} fail!", field.getName(), type));
                    return;
                }
                ReflectionUtils.makeAccessible((Field)field);
                try {
                    field.set(instance, value);
                    ArkLoggerFactory.getDefaultLogger().info(String.format("Inject {field= %s} of {service= %s} success!", field.getName(), type));
                }
                catch (Throwable throwable) {
                    throw new ArkRuntimeException(throwable);
                }
            }
        });
    }

    private Object getService(Class serviceType, String uniqueId) {
        ServiceReference serviceReference = this.registryService.referenceService(serviceType, uniqueId);
        return serviceReference == null ? null : serviceReference.getService();
    }
}

