/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.service.binding;

import com.alipay.sofa.boot.util.ClassLoaderContextUtils;
import com.alipay.sofa.runtime.api.binding.BindingType;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.binding.JvmBindingInterface;
import com.alipay.sofa.runtime.service.binding.JvmServiceInvoker;
import com.alipay.sofa.runtime.spi.binding.BindingAdapter;
import com.alipay.sofa.runtime.spi.binding.Contract;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;

public class JvmBindingAdapter
implements BindingAdapter<JvmBinding> {
    @Override
    public void preOutBinding(Object contract, JvmBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
    }

    @Override
    public Object outBinding(Object contract, JvmBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        return null;
    }

    @Override
    public void preUnoutBinding(Object contract, JvmBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
    }

    @Override
    public void postUnoutBinding(Object contract, JvmBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
    }

    @Override
    public BindingType getBindingType() {
        return JvmBinding.JVM_BINDING_TYPE;
    }

    @Override
    public Class<JvmBinding> getBindingClass() {
        return JvmBinding.class;
    }

    @Override
    public Object inBinding(Object contract, JvmBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        return this.createServiceProxy((Contract)contract, binding, sofaRuntimeContext);
    }

    @Override
    public void unInBinding(Object contract, JvmBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        binding.setDestroyed(true);
        if (binding.hasBackupProxy()) {
            binding.setBackupProxy(null);
        }
    }

    private Object createServiceProxy(Contract contract, JvmBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        ClassLoader newClassLoader;
        ClassLoader appClassLoader = sofaRuntimeContext.getAppClassLoader();
        Class<?> javaClass = contract.getInterfaceType();
        try {
            Class<?> appLoadedClass = appClassLoader.loadClass(javaClass.getName());
            newClassLoader = appLoadedClass == javaClass ? appClassLoader : javaClass.getClassLoader();
        }
        catch (ClassNotFoundException e) {
            newClassLoader = javaClass.getClassLoader();
        }
        ClassLoader finalClassLoader = newClassLoader;
        return ClassLoaderContextUtils.callWithTemporaryContextClassloader(() -> {
            JvmServiceInvoker handler = new JvmServiceInvoker(contract, binding, sofaRuntimeContext);
            ProxyFactory factory = new ProxyFactory();
            if (javaClass.isInterface()) {
                factory.addInterface(javaClass);
                factory.addInterface(JvmBindingInterface.class);
            } else {
                factory.setTargetClass(javaClass);
                factory.setProxyTargetClass(true);
            }
            factory.addAdvice((Advice)handler);
            return factory.getProxy(finalClassLoader);
        }, (ClassLoader)finalClassLoader);
    }
}

