/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.ext.component;

import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.component.ComponentLifeCycle;
import com.alipay.sofa.runtime.ext.component.ExtensionComponent;
import com.alipay.sofa.runtime.ext.spring.SpringImplementationImpl;
import com.alipay.sofa.runtime.model.ComponentStatus;
import com.alipay.sofa.runtime.model.ComponentType;
import com.alipay.sofa.runtime.spi.component.AbstractComponent;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.ComponentManager;
import com.alipay.sofa.runtime.spi.component.ComponentNameFactory;
import com.alipay.sofa.runtime.spi.component.Implementation;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.service.api.component.ExtensionPoint;

public class ExtensionPointComponent
extends AbstractComponent {
    private static final String LINK_SYMBOL = "$";
    public static final ComponentType EXTENSION_POINT_COMPONENT_TYPE = new ComponentType("extension-point");
    private final ExtensionPoint extensionPoint;

    public ExtensionPointComponent(ExtensionPoint extensionPoint, SofaRuntimeContext sofaRuntimeContext, Implementation implementation) {
        this.extensionPoint = extensionPoint;
        this.sofaRuntimeContext = sofaRuntimeContext;
        this.implementation = implementation;
        this.componentName = ComponentNameFactory.createComponentName(EXTENSION_POINT_COMPONENT_TYPE, implementation.getName() + LINK_SYMBOL + this.extensionPoint.getName());
    }

    @Override
    public ComponentType getType() {
        return EXTENSION_POINT_COMPONENT_TYPE;
    }

    @Override
    public void activate() throws ServiceRuntimeException {
        super.activate();
        ComponentManager componentManager = this.sofaRuntimeContext.getComponentManager();
        for (ComponentInfo componentInfo : componentManager.getComponents()) {
            ExtensionComponent extensionComponent;
            if (!componentInfo.getType().equals(ExtensionComponent.EXTENSION_COMPONENT_TYPE) || componentInfo.isResolved() || !(extensionComponent = (ExtensionComponent)componentInfo).getExtension().getTargetComponentName().equals(this.componentName)) continue;
            componentManager.resolvePendingResolveComponent(componentInfo.getName());
        }
    }

    @Override
    public void deactivate() throws ServiceRuntimeException {
        Object target;
        ComponentManager componentManager = this.sofaRuntimeContext.getComponentManager();
        for (ComponentInfo componentInfo : componentManager.getComponents()) {
            ExtensionComponent extensionComponent;
            if (!componentInfo.getType().equals(ExtensionComponent.EXTENSION_COMPONENT_TYPE) || !(extensionComponent = (ExtensionComponent)componentInfo).getExtension().getTargetComponentName().equals(this.componentName)) continue;
            componentManager.unregister(componentInfo);
        }
        if (this.componentStatus != ComponentStatus.ACTIVATED) {
            return;
        }
        if (this.implementation != null && !(this.implementation instanceof SpringImplementationImpl) && (target = this.implementation.getTarget()) instanceof ComponentLifeCycle) {
            ((ComponentLifeCycle)target).deactivate();
        }
        this.componentStatus = ComponentStatus.RESOLVED;
    }

    public ExtensionPoint getExtensionPoint() {
        return this.extensionPoint;
    }
}

