/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.parser;

import com.alipay.sofa.boot.spring.namespace.spi.SofaBootTagNameSupport;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractContractDefinitionParser
extends AbstractSingleBeanDefinitionParser
implements SofaBootTagNameSupport {
    public static final String INTERFACE_ELEMENT = "interface";
    public static final String INTERFACE_PROPERTY = "interfaceType";
    public static final String INTERFACE_CLASS_PROPERTY = "interfaceClass";
    public static final String BEAN_ID_ELEMENT = "id";
    public static final String BEAN_ID_PROPERTY = "beanId";
    public static final String UNIQUE_ID_ELEMENT = "unique-id";
    public static final String UNIQUE_ID_PROPERTY = "uniqueId";
    public static final String ELEMENTS = "elements";
    public static final String BINDINGS = "bindings";
    public static final String REPEAT_REFER_LIMIT_ELEMENT = "repeatReferLimit";
    public static final String REPEAT_REFER_LIMIT_PROPERTY = "repeatReferLimit";
    public static final String DEFINITION_BUILDING_API_TYPE = "apiType";
    public static final String SOFA_RUNTIME_CONTEXT = "sofaRuntimeContext";
    public static final String BINDING_CONVERTER_FACTORY = "bindingConverterFactory";
    public static final String BINDING_ADAPTER_FACTORY = "bindingAdapterFactory";

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addAutowiredProperty(SOFA_RUNTIME_CONTEXT);
        builder.addAutowiredProperty(BINDING_CONVERTER_FACTORY);
        builder.addAutowiredProperty(BINDING_ADAPTER_FACTORY);
        String id = element.getAttribute(BEAN_ID_ELEMENT);
        builder.addPropertyValue(BEAN_ID_PROPERTY, (Object)id);
        String interfaceType = element.getAttribute(INTERFACE_ELEMENT);
        builder.addPropertyValue(INTERFACE_PROPERTY, (Object)interfaceType);
        builder.getBeanDefinition().getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)interfaceType);
        String uniqueId = element.getAttribute(UNIQUE_ID_ELEMENT);
        builder.addPropertyValue(UNIQUE_ID_PROPERTY, (Object)uniqueId);
        String repeatReferLimit = element.getAttribute("repeatReferLimit");
        builder.addPropertyValue("repeatReferLimit", (Object)repeatReferLimit);
        List childElements = DomUtils.getChildElements((Element)element);
        ArrayList<TypedStringValue> elementAsTypedStringValueList = new ArrayList<TypedStringValue>();
        for (Element childElement : childElements) {
            try {
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                StringWriter buffer = new StringWriter();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(childElement), new StreamResult(buffer));
                String str = buffer.toString();
                elementAsTypedStringValueList.add(new TypedStringValue(str, Element.class));
            }
            catch (Throwable e) {
                throw new ServiceRuntimeException(e);
            }
        }
        builder.addPropertyValue("documentEncoding", (Object)element.getOwnerDocument().getXmlEncoding());
        builder.addPropertyValue(ELEMENTS, elementAsTypedStringValueList);
        this.doParseInternal(element, parserContext, builder);
    }

    protected abstract void doParseInternal(Element var1, ParserContext var2, BeanDefinitionBuilder var3);
}

