/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring;

import com.alipay.sofa.runtime.spi.binding.BindingAdapterFactory;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.service.BindingConverterFactory;
import com.alipay.sofa.runtime.spring.ClientFactoryAnnotationBeanPostProcessor;
import com.alipay.sofa.runtime.spring.ReferenceAnnotationBeanPostProcessor;
import com.alipay.sofa.runtime.spring.SofaRuntimeAwareProcessor;
import com.alipay.sofa.runtime.spring.bean.SofaParameterNameDiscoverer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
public class RuntimeContextBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    protected BindingAdapterFactory bindingAdapterFactory;
    protected BindingConverterFactory bindingConverterFactory;
    protected SofaRuntimeContext sofaRuntimeContext;
    protected ApplicationContext applicationContext;

    public RuntimeContextBeanFactoryPostProcessor() {
    }

    @Deprecated
    public RuntimeContextBeanFactoryPostProcessor(BindingAdapterFactory bindingAdapterFactory, BindingConverterFactory bindingConverterFactory, SofaRuntimeContext sofaRuntimeContext) {
        this.bindingAdapterFactory = bindingAdapterFactory;
        this.bindingConverterFactory = bindingConverterFactory;
        this.sofaRuntimeContext = sofaRuntimeContext;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new SofaRuntimeAwareProcessor(this.sofaRuntimeContext.getSofaRuntimeManager()));
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ClientFactoryAnnotationBeanPostProcessor(this.sofaRuntimeContext.getClientFactory()));
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ReferenceAnnotationBeanPostProcessor(this.applicationContext, this.sofaRuntimeContext, this.bindingAdapterFactory, this.bindingConverterFactory));
        if (beanFactory instanceof AbstractAutowireCapableBeanFactory) {
            ((AbstractAutowireCapableBeanFactory)beanFactory).setParameterNameDiscoverer((ParameterNameDiscoverer)new SofaParameterNameDiscoverer(this.applicationContext.getEnvironment()));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.bindingAdapterFactory = (BindingAdapterFactory)applicationContext.getBean("bindingAdapterFactory", BindingAdapterFactory.class);
        this.bindingConverterFactory = (BindingConverterFactory)applicationContext.getBean("bindingConverterFactory", BindingConverterFactory.class);
        this.sofaRuntimeContext = (SofaRuntimeContext)applicationContext.getBean("sofaRuntimeContext", SofaRuntimeContext.class);
    }
}

