/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.invoke;

import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.BizState;
import com.alipay.sofa.ark.spi.replay.ReplayContext;
import com.alipay.sofa.ark.spi.service.ArkInject;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;
import com.alipay.sofa.common.utils.StringUtil;
import com.alipay.sofa.runtime.SofaFramework;
import com.alipay.sofa.runtime.SofaRuntimeProperties;
import com.alipay.sofa.runtime.invoke.JvmServiceTargetHabitat;
import com.alipay.sofa.runtime.log.SofaLogger;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.component.Service;
import com.alipay.sofa.runtime.service.component.ServiceComponent;
import com.alipay.sofa.runtime.spi.binding.Contract;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.ComponentManager;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;
import com.alipay.sofa.runtime.spi.service.ServiceProxy;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInvocation;

public class DynamicJvmServiceProxyFinder {
    private static DynamicJvmServiceProxyFinder dynamicJvmServiceProxyFinder = new DynamicJvmServiceProxyFinder();
    private static Map<String, JvmServiceTargetHabitat> jvmServiceTargetHabitats = new ConcurrentHashMap<String, JvmServiceTargetHabitat>();
    @ArkInject
    private BizManagerService bizManagerService;
    private boolean hasFinishStartup = false;

    private DynamicJvmServiceProxyFinder() {
    }

    public static DynamicJvmServiceProxyFinder getDynamicJvmServiceProxyFinder() {
        return dynamicJvmServiceProxyFinder;
    }

    public ServiceComponent findServiceComponent(ClassLoader clientClassloader, Contract contract) {
        ServiceComponent serviceComponent = null;
        if (this.hasFinishStartup && SofaRuntimeProperties.isDynamicJvmServiceCacheEnable() && (serviceComponent = this.cacheSearching(contract)) != null) {
            return serviceComponent;
        }
        String interfaceType = contract.getInterfaceTypeCanonicalName();
        String uniqueId = contract.getUniqueId();
        for (SofaRuntimeManager sofaRuntimeManager : SofaFramework.getRuntimeSet()) {
            Biz biz;
            if (sofaRuntimeManager.getAppClassLoader().equals(clientClassloader)) continue;
            String version = ReplayContext.get();
            if ("__call_placeholder__".equals(version)) {
                version = null;
            }
            if ((biz = DynamicJvmServiceProxyFinder.getBiz(sofaRuntimeManager)) == null || this.hasFinishStartup && biz.getBizState() != BizState.DEACTIVATED && biz.getBizState() != BizState.ACTIVATED || version != null && !version.equals(biz.getBizVersion()) || this.hasFinishStartup && version == null && biz.getBizState() != BizState.ACTIVATED || (serviceComponent = this.findServiceComponent(uniqueId, interfaceType, sofaRuntimeManager.getComponentManager())) == null) continue;
            return serviceComponent;
        }
        return null;
    }

    public void afterBizStartup(Biz biz) {
        if (!SofaRuntimeProperties.isDynamicJvmServiceCacheEnable()) {
            return;
        }
        for (SofaRuntimeManager runtimeManager : SofaFramework.getRuntimeSet()) {
            if (!runtimeManager.getAppClassLoader().equals(biz.getBizClassLoader())) continue;
            for (ComponentInfo componentInfo : runtimeManager.getComponentManager().getComponents()) {
                if (!(componentInfo instanceof ServiceComponent)) continue;
                ServiceComponent serviceComponent = (ServiceComponent)componentInfo;
                String uniqueName = this.getUniqueName(serviceComponent.getService());
                jvmServiceTargetHabitats.computeIfAbsent(uniqueName, e -> new JvmServiceTargetHabitat(biz.getBizName()));
                JvmServiceTargetHabitat jvmServiceTargetHabitat = jvmServiceTargetHabitats.get(uniqueName);
                jvmServiceTargetHabitat.addServiceComponent(biz.getBizVersion(), serviceComponent);
            }
        }
    }

    public void afterBizUninstall(Biz biz) {
        if (!SofaRuntimeProperties.isDynamicJvmServiceCacheEnable()) {
            return;
        }
        for (SofaRuntimeManager runtimeManager : SofaFramework.getRuntimeSet()) {
            if (!runtimeManager.getAppClassLoader().equals(biz.getBizClassLoader())) continue;
            for (ComponentInfo componentInfo : runtimeManager.getComponentManager().getComponents()) {
                ServiceComponent serviceComponent;
                String uniqueName;
                JvmServiceTargetHabitat jvmServiceTargetHabitat;
                if (!(componentInfo instanceof ServiceComponent) || (jvmServiceTargetHabitat = jvmServiceTargetHabitats.get(uniqueName = this.getUniqueName((serviceComponent = (ServiceComponent)componentInfo).getService()))) == null) continue;
                jvmServiceTargetHabitat.removeServiceComponent(biz.getBizVersion());
            }
        }
    }

    private ServiceComponent cacheSearching(Contract contract) {
        if (!this.hasFinishStartup) {
            return null;
        }
        String uniqueName = this.getUniqueName(contract);
        JvmServiceTargetHabitat jvmServiceTargetHabitat = jvmServiceTargetHabitats.get(uniqueName);
        if (jvmServiceTargetHabitat == null) {
            return null;
        }
        String version = ReplayContext.get();
        String string = version = "__call_placeholder__".equals(version) ? null : version;
        if (StringUtil.isNotBlank((String)version)) {
            return jvmServiceTargetHabitat.getServiceComponent(version);
        }
        return jvmServiceTargetHabitat.getDefaultServiceComponent();
    }

    private String getUniqueName(Contract contract) {
        String uniqueName = contract.getInterfaceType().getName();
        if (StringUtil.isNotBlank((String)contract.getUniqueId())) {
            uniqueName = uniqueName + ":" + contract.getUniqueId();
        }
        return uniqueName;
    }

    public ServiceProxy findServiceProxy(ClassLoader clientClassloader, Contract contract) {
        ServiceComponent serviceComponent = this.findServiceComponent(clientClassloader, contract);
        if (serviceComponent == null) {
            return null;
        }
        SofaRuntimeManager sofaRuntimeManager = serviceComponent.getContext().getSofaRuntimeManager();
        Biz biz = DynamicJvmServiceProxyFinder.getBiz(sofaRuntimeManager);
        if (biz == null) {
            return null;
        }
        JvmBinding referenceJvmBinding = (JvmBinding)contract.getBinding(JvmBinding.JVM_BINDING_TYPE);
        JvmBinding serviceJvmBinding = (JvmBinding)serviceComponent.getService().getBinding(JvmBinding.JVM_BINDING_TYPE);
        boolean serialize = serviceJvmBinding != null ? referenceJvmBinding.getJvmBindingParam().isSerialize() || serviceJvmBinding.getJvmBindingParam().isSerialize() : true;
        return new DynamicJvmServiceInvoker(clientClassloader, sofaRuntimeManager.getAppClassLoader(), serviceComponent.getService().getTarget(), contract, biz.getIdentity(), serialize);
    }

    private ServiceComponent findServiceComponent(String uniqueId, String interfaceType, ComponentManager componentManager) {
        Collection<ComponentInfo> components = componentManager.getComponentInfosByType(ServiceComponent.SERVICE_COMPONENT_TYPE);
        for (ComponentInfo c : components) {
            ServiceComponent component = (ServiceComponent)c;
            Service serviceContract = component.getService();
            if (!serviceContract.getInterfaceTypeCanonicalName().equals(interfaceType) || !uniqueId.equals(serviceContract.getUniqueId())) continue;
            return component;
        }
        return null;
    }

    public static Biz getBiz(SofaRuntimeManager sofaRuntimeManager) {
        if (DynamicJvmServiceProxyFinder.getDynamicJvmServiceProxyFinder().bizManagerService == null) {
            return null;
        }
        for (Biz biz : DynamicJvmServiceProxyFinder.getDynamicJvmServiceProxyFinder().bizManagerService.getBizInOrder()) {
            if (!sofaRuntimeManager.getAppClassLoader().equals(biz.getBizClassLoader())) continue;
            return biz;
        }
        return null;
    }

    public void setHasFinishStartup(boolean hasFinishStartup) {
        this.hasFinishStartup = hasFinishStartup;
    }

    static class DynamicJvmServiceInvoker
    extends ServiceProxy {
        private Contract contract;
        private Object targetService;
        private String bizIdentity;
        private ThreadLocal<ClassLoader> clientClassloader = new ThreadLocal();
        private boolean serialize;
        protected static final String TOSTRING_METHOD = "toString";
        protected static final String EQUALS_METHOD = "equals";
        protected static final String HASHCODE_METHOD = "hashCode";

        public DynamicJvmServiceInvoker(ClassLoader clientClassloader, ClassLoader serviceClassLoader, Object targetService, Contract contract, String bizIdentity, boolean serialize) {
            super(serviceClassLoader);
            this.clientClassloader.set(clientClassloader);
            this.targetService = targetService;
            this.contract = contract;
            this.bizIdentity = bizIdentity;
            this.serialize = serialize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object doInvoke(MethodInvocation invocation) throws Throwable {
            Object[] arguments;
            Class[] oldArgumentTypes;
            Method targetMethod;
            try {
                if (SofaLogger.isDebugEnabled()) {
                    SofaLogger.debug(">> Start in Cross App JVM service invoke, the service interface is  - " + this.getInterfaceType());
                }
                if (DynamicJvmServiceProxyFinder.getDynamicJvmServiceProxyFinder().bizManagerService != null) {
                    ReplayContext.setPlaceHolder();
                }
                targetMethod = invocation.getMethod();
                Object[] targetArguments = invocation.getArguments();
                if (TOSTRING_METHOD.equalsIgnoreCase(targetMethod.getName()) && targetMethod.getParameterTypes().length == 0) {
                    String string = this.targetService.toString();
                    return string;
                }
                if (EQUALS_METHOD.equalsIgnoreCase(targetMethod.getName()) && targetMethod.getParameterTypes().length == 1) {
                    Boolean bl = this.targetService.equals(targetArguments[0]);
                    return bl;
                }
                if (HASHCODE_METHOD.equalsIgnoreCase(targetMethod.getName()) && targetMethod.getParameterTypes().length == 0) {
                    Integer n = this.targetService.hashCode();
                    return n;
                }
                oldArgumentTypes = targetMethod.getParameterTypes();
                if (!this.serialize || SofaRuntimeProperties.isSkipJvmSerialize(this.clientClassloader.get()).booleanValue()) {
                    ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                    try {
                        this.pushThreadContextClassLoader(this.getServiceClassLoader());
                        Method transformMethod = this.getTargetMethod(targetMethod, oldArgumentTypes);
                        Object object = transformMethod.invoke(this.targetService, targetArguments);
                        return object;
                    }
                    finally {
                        this.pushThreadContextClassLoader(tcl);
                    }
                }
                arguments = (Object[])DynamicJvmServiceInvoker.hessianTransport(targetArguments, null);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            finally {
                if (DynamicJvmServiceProxyFinder.getDynamicJvmServiceProxyFinder().bizManagerService != null) {
                    ReplayContext.clearPlaceHolder();
                }
                this.clearClientClassloader();
            }
            Class[] argumentTypes = (Class[])DynamicJvmServiceInvoker.hessianTransport(oldArgumentTypes, null);
            Method transformMethod = this.getTargetMethod(targetMethod, argumentTypes);
            Object retVal = transformMethod.invoke(this.targetService, arguments);
            Object object = DynamicJvmServiceInvoker.hessianTransport(retVal, this.getClientClassloader());
            return object;
        }

        @Override
        protected void doCatch(MethodInvocation invocation, Throwable e, long startTime) {
            if (SofaLogger.isDebugEnabled()) {
                SofaLogger.debug(this.getCommonInvocationLog("Exception", invocation, startTime));
            }
        }

        @Override
        protected void doFinally(MethodInvocation invocation, long startTime) {
            if (SofaLogger.isDebugEnabled()) {
                SofaLogger.debug(this.getCommonInvocationLog("Finally", invocation, startTime));
            }
        }

        private Class getInterfaceType() {
            return this.contract.getInterfaceType();
        }

        public ClassLoader getClientClassloader() {
            return this.clientClassloader.get();
        }

        public void setClientClassloader(ClassLoader clientClassloader) {
            this.clientClassloader.set(clientClassloader);
        }

        public void clearClientClassloader() {
            this.clientClassloader.remove();
        }

        private Method getTargetMethod(Method method, Class[] argumentTypes) {
            try {
                return this.targetService.getClass().getMethod(method.getName(), argumentTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(this.targetService + " in " + this.bizIdentity + " don't have the method " + method);
            }
        }

        private static Object hessianTransport(Object source, ClassLoader contextClassLoader) {
            Object target;
            ClassLoader currentContextClassloader = Thread.currentThread().getContextClassLoader();
            try {
                if (contextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
                SerializerFactory serializerFactory = new SerializerFactory();
                serializerFactory.setAllowNonSerializable(true);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                Hessian2Output h2o = new Hessian2Output((OutputStream)bos);
                h2o.setSerializerFactory(serializerFactory);
                h2o.writeObject(source);
                h2o.flush();
                byte[] content = bos.toByteArray();
                Hessian2Input h2i = new Hessian2Input((InputStream)new ByteArrayInputStream(content));
                h2i.setSerializerFactory(serializerFactory);
                target = h2i.readObject();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentContextClassloader);
            }
            return target;
        }
    }
}

