/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.ext.spring;

import com.alipay.sofa.runtime.api.component.ComponentName;
import com.alipay.sofa.runtime.api.component.Property;
import com.alipay.sofa.runtime.ext.component.ExtensionComponent;
import com.alipay.sofa.runtime.ext.component.ExtensionPointComponent;
import com.alipay.sofa.runtime.ext.spring.AbstractExtFactoryBean;
import com.alipay.sofa.runtime.ext.spring.ExtensionBuilder;
import com.alipay.sofa.runtime.log.SofaLogger;
import com.alipay.sofa.runtime.model.InterfaceMode;
import com.alipay.sofa.runtime.spi.component.ComponentDefinitionInfo;
import com.alipay.sofa.runtime.spi.util.ComponentNameFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ExtensionFactoryBean
extends AbstractExtFactoryBean {
    private String bean;
    private String point;
    private Element content;
    private String[] require;
    private ClassLoader classLoader;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.applicationContext, (String)"required property 'applicationContext' has not been set");
        Assert.notNull((Object)this.getPoint(), (String)"required property 'point' has not been set for extension");
        if (!StringUtils.hasText((String)this.getPoint())) {
            throw new IllegalArgumentException("'point' have to be specified");
        }
        this.classLoader = this.getBeanClassLoaderWrapper() == null || this.getBeanClassLoaderWrapper().getInnerClassLoader() == null ? Thread.currentThread().getContextClassLoader() : this.getBeanClassLoaderWrapper().getInnerClassLoader();
        try {
            this.publishAsNuxeoExtension();
        }
        catch (Exception e) {
            SofaLogger.error("failed to publish extension", e);
            throw e;
        }
    }

    private void publishAsNuxeoExtension() throws Exception {
        ExtensionBuilder extensionBuilder = ExtensionBuilder.genericExtension(this.getPoint(), this.getContent(), this.applicationContext, this.classLoader);
        extensionBuilder.setExtensionPoint(this.getExtensionPointComponentName());
        ExtensionComponent componentInfo = new ExtensionComponent(extensionBuilder.getExtension(), this.sofaRuntimeContext);
        ComponentDefinitionInfo extensionDefinitionInfo = new ComponentDefinitionInfo();
        extensionDefinitionInfo.setInterfaceMode(InterfaceMode.spring);
        extensionDefinitionInfo.putInfo("beanId", this.bean);
        extensionDefinitionInfo.putInfo("pointName", this.point);
        Property property = new Property();
        property.setName("source");
        property.setValue(extensionDefinitionInfo);
        componentInfo.getProperties().put("source", property);
        componentInfo.setApplicationContext(this.applicationContext);
        this.sofaRuntimeContext.getComponentManager().register(componentInfo);
    }

    private ComponentName getExtensionPointComponentName() {
        return ComponentNameFactory.createComponentName(ExtensionPointComponent.EXTENSION_POINT_COMPONENT_TYPE, this.getBean() + "$" + this.getPoint());
    }

    @Override
    @Deprecated
    public void setBeanClassLoader(ClassLoader classLoader) {
        throw new UnsupportedOperationException("Not support setBeanClassLoader for security");
    }

    public void setContribution(String[] contribution) throws Exception {
        if (contribution != null && contribution.length != 0) {
            Class[] contrClass = new Class[contribution.length];
            int i = 0;
            for (String cntr : contribution) {
                contrClass[i] = this.classLoader.loadClass(cntr);
                ++i;
            }
        }
    }

    public void setRequire(String[] require) {
        this.require = require;
    }

    public String[] getRequire() {
        return this.require;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public String getBean() {
        return this.bean;
    }

    public void setContent(Element content) {
        this.content = content;
    }

    public Element getContent() {
        return this.content;
    }

    public void setPoint(String point) {
        this.point = point;
    }

    public String getPoint() {
        return this.point;
    }

    public String toString() {
        return "ExtensionPointTarget: " + this.bean;
    }
}

