/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.ext.component;

import com.alipay.sofa.common.xmap.Context;
import com.alipay.sofa.common.xmap.XMap;
import com.alipay.sofa.runtime.ext.component.ExtensionInternal;
import com.alipay.sofa.runtime.ext.component.ExtensionPointInternal;
import com.alipay.sofa.runtime.ext.component.XMapContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.ClassUtils;

public class ExtensionPointImpl
implements ExtensionPointInternal,
Serializable {
    private static final long serialVersionUID = 3939941819263075106L;
    protected String name;
    protected String documentation;
    protected transient List<Class<?>> contributions = new ArrayList(2);
    protected ClassLoader beanClassLoader;

    public ExtensionPointImpl(String name, Class<?> contributionClass) {
        this.name = name;
        if (contributionClass != null) {
            this.contributions.add(contributionClass);
        }
    }

    @Override
    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Override
    public List<Class<?>> getContributions() {
        return this.contributions;
    }

    @Override
    public boolean hasContribution() {
        return this.contributions.size() > 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    @Override
    public void addContribution(Class<?> javaClass) {
        this.contributions.add(javaClass);
    }

    @Override
    public void addContribution(String className) {
        this.addContribution(ClassUtils.resolveClassName((String)className, (ClassLoader)this.beanClassLoader));
    }

    @Override
    public Object[] loadContributions(ExtensionInternal extension) throws Exception {
        if (this.contributions != null) {
            XMap xmap = new XMap();
            for (Class<?> contrib : this.contributions) {
                xmap.register(contrib);
            }
            Object[] contributions = xmap.loadAll((Context)new XMapContext(extension.getAppClassLoader()), extension.getElement());
            extension.setContributions(contributions);
            return contributions;
        }
        return null;
    }
}

