/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.api.ArkConfigs;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.runtime.log.SofaLogger;
import java.util.List;
import org.springframework.util.Assert;

public class SofaRuntimeUtils {
    private static final String ARK_BIZ_CLASSLOADER_NAME = "com.alipay.sofa.ark.container.service.classloader.BizClassLoader";
    private static Object masterBiz;

    public static boolean isArkEnvironment() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return tccl != null && ARK_BIZ_CLASSLOADER_NAME.equals(tccl.getClass().getName());
    }

    public static boolean onMasterBiz() {
        try {
            if (masterBiz == null) {
                String masterBizName = ArkConfigs.getStringValue((String)"com.alipay.sofa.ark.master.biz");
                List biz = ArkClient.getBizManagerService().getBiz(masterBizName);
                Assert.isTrue((biz.size() == 1 ? 1 : 0) != 0, (String)"master biz should have and only have one.");
                masterBiz = biz.get(0);
            }
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            return tccl.equals(((Biz)masterBiz).getBizClassLoader());
        }
        catch (Throwable e) {
            SofaLogger.info("Assume normal SOFABoot environment because Loading of master biz fails with error:", e);
            throw e;
        }
    }
}

