/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring.parser;

import com.alipay.sofa.boot.spring.namespace.spi.SofaBootTagNameSupport;
import com.alipay.sofa.runtime.factory.BeanLoadCostBeanFactory;
import com.alipay.sofa.runtime.spring.async.AsyncInitBeanHolder;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AsyncInitBeanDefinitionDecorator
implements BeanDefinitionDecorator,
SofaBootTagNameSupport {
    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
        if (!Boolean.TRUE.toString().equalsIgnoreCase(((Attr)node).getValue())) {
            return definition;
        }
        String moduleName = this.getModuleName(parserContext);
        if (moduleName != null && moduleName.trim().length() > 0) {
            AsyncInitBeanHolder.registerAsyncInitBean(moduleName, definition.getBeanName(), ((AbstractBeanDefinition)definition.getBeanDefinition()).getInitMethodName());
        }
        return definition;
    }

    public String supportTagName() {
        return "async-init";
    }

    private String getModuleName(ParserContext parserContext) {
        ConfigurableListableBeanFactory beanFactory;
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (registry instanceof AbstractApplicationContext && (beanFactory = ((AbstractApplicationContext)registry).getBeanFactory()) instanceof BeanLoadCostBeanFactory) {
            return ((BeanLoadCostBeanFactory)beanFactory).getId();
        }
        if (registry instanceof BeanLoadCostBeanFactory) {
            return ((BeanLoadCostBeanFactory)registry).getId();
        }
        return "RootApplicationContext";
    }

    public static boolean isBeanLoadCostBeanFactory(Class factoryClass) {
        if (factoryClass == null) {
            return false;
        }
        return BeanLoadCostBeanFactory.class.isAssignableFrom(factoryClass);
    }
}

