/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring;

import com.alipay.sofa.boot.error.ErrorCode;
import com.alipay.sofa.runtime.api.annotation.SofaClientFactory;
import com.alipay.sofa.runtime.api.client.ClientFactory;
import com.alipay.sofa.runtime.client.impl.ClientFactoryImpl;
import com.alipay.sofa.runtime.spring.singleton.SingletonSofaPostProcessor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ReflectionUtils;

@SingletonSofaPostProcessor
public class ClientFactoryAnnotationBeanPostProcessor
implements BeanPostProcessor,
PriorityOrdered {
    private ClientFactory clientFactory;

    public ClientFactoryAnnotationBeanPostProcessor(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public Object postProcessBeforeInitialization(final Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                if (field.getType().equals(ClientFactory.class)) {
                    ReflectionUtils.makeAccessible((Field)field);
                    ReflectionUtils.setField((Field)field, (Object)bean, (Object)ClientFactoryAnnotationBeanPostProcessor.this.clientFactory);
                } else if (ClientFactoryAnnotationBeanPostProcessor.this.clientFactory instanceof ClientFactoryImpl && ((ClientFactoryImpl)ClientFactoryAnnotationBeanPostProcessor.this.clientFactory).getAllClientTypes().contains(field.getType())) {
                    Object client = ClientFactoryAnnotationBeanPostProcessor.this.clientFactory.getClient(field.getType());
                    ReflectionUtils.makeAccessible((Field)field);
                    ReflectionUtils.setField((Field)field, (Object)bean, client);
                } else {
                    throw new RuntimeException(ErrorCode.convert((String)"01-02000"));
                }
            }
        }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

            public boolean matches(Field field) {
                return !Modifier.isStatic(field.getModifiers()) && field.isAnnotationPresent(SofaClientFactory.class);
            }
        });
        return bean;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

