/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.component.impl;

import com.alipay.sofa.boot.error.ErrorCode;
import com.alipay.sofa.runtime.SofaRuntimeProperties;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.component.ComponentName;
import com.alipay.sofa.runtime.log.SofaLogger;
import com.alipay.sofa.runtime.model.ComponentStatus;
import com.alipay.sofa.runtime.model.ComponentType;
import com.alipay.sofa.runtime.spi.client.ClientFactoryInternal;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.ComponentManager;
import com.alipay.sofa.runtime.spring.SpringContextComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;

public class ComponentManagerImpl
implements ComponentManager {
    protected ConcurrentMap<ComponentName, ComponentInfo> registry = new ConcurrentHashMap<ComponentName, ComponentInfo>(16);
    protected ConcurrentMap<ComponentType, Map<ComponentName, ComponentInfo>> resolvedRegistry = new ConcurrentHashMap<ComponentType, Map<ComponentName, ComponentInfo>>(16);
    private ClientFactoryInternal clientFactoryInternal;
    private final ClassLoader appClassLoader;

    public ComponentManagerImpl(ClientFactoryInternal clientFactoryInternal, ClassLoader appClassLoader) {
        this.clientFactoryInternal = clientFactoryInternal;
        this.appClassLoader = appClassLoader;
    }

    public Collection<ComponentInfo> getComponentInfos() {
        return new ArrayList<ComponentInfo>(this.registry.values());
    }

    public Collection<ComponentName> getPendingComponentInfos() {
        ArrayList<ComponentName> names = new ArrayList<ComponentName>();
        for (ComponentInfo ri : this.registry.values()) {
            if (ri.getState() != ComponentStatus.REGISTERED) continue;
            names.add(ri.getName());
        }
        return names;
    }

    @Override
    public ComponentInfo getComponentInfo(ComponentName name) {
        return (ComponentInfo)this.registry.get(name);
    }

    @Override
    public boolean isRegistered(ComponentName name) {
        return this.registry.containsKey(name);
    }

    @Override
    public Collection<ComponentInfo> getComponents() {
        return this.registry.values();
    }

    @Override
    public int size() {
        return this.registry.size();
    }

    @Override
    public void shutdown() {
        if (SofaRuntimeProperties.isSkipAllComponentShutdown(this.appClassLoader)) {
            return;
        }
        ArrayList elems = new ArrayList(this.registry.values());
        List springContextComponents = elems.stream().filter(componentInfo -> componentInfo instanceof SpringContextComponent).collect(Collectors.toList());
        for (ComponentInfo ri : springContextComponents) {
            try {
                this.unregister(ri);
            }
            catch (Throwable t) {
                SofaLogger.error(ErrorCode.convert((String)"01-03001", (Object[])new Object[]{ri.getName()}), t);
            }
        }
        if (!springContextComponents.isEmpty()) {
            elems.removeAll(springContextComponents);
        }
        if (SofaRuntimeProperties.isSkipCommonComponentShutdown(this.appClassLoader)) {
            return;
        }
        for (ComponentInfo ri : elems) {
            try {
                this.unregister(ri);
            }
            catch (Throwable t) {
                SofaLogger.error(ErrorCode.convert((String)"01-03001", (Object[])new Object[]{ri.getName()}), t);
            }
        }
        try {
            if (this.registry != null) {
                this.registry.clear();
            }
            if (this.resolvedRegistry != null) {
                this.resolvedRegistry.clear();
            }
            this.clientFactoryInternal = null;
        }
        catch (Throwable t) {
            SofaLogger.error(ErrorCode.convert((String)"01-03000"), t);
        }
    }

    @Override
    public Collection<ComponentType> getComponentTypes() {
        return this.resolvedRegistry.keySet();
    }

    @Override
    public void register(ComponentInfo componentInfo) {
        this.doRegister(componentInfo);
    }

    @Override
    public ComponentInfo registerAndGet(ComponentInfo componentInfo) {
        return this.doRegister(componentInfo);
    }

    @Override
    public void registerComponentClient(Class<?> clientType, Object client) {
        this.clientFactoryInternal.registerClient(clientType, client);
    }

    private ComponentInfo doRegister(ComponentInfo ci) {
        ComponentName name = ci.getName();
        if (this.isRegistered(name)) {
            SofaLogger.warn("Component was already registered: {}", (Object)name);
            if (ci.canBeDuplicate()) {
                return this.getComponentInfo(name);
            }
            throw new ServiceRuntimeException(ErrorCode.convert((String)"01-03002", (Object[])new Object[]{name}));
        }
        try {
            ci.register();
        }
        catch (Throwable t) {
            SofaLogger.error(ErrorCode.convert((String)"01-03003", (Object[])new Object[]{ci.getName()}), t);
            return null;
        }
        SofaLogger.info("Registering component: {}", (Object)ci.getName());
        try {
            ComponentInfo old = this.registry.putIfAbsent(ci.getName(), ci);
            if (old != null) {
                SofaLogger.warn("Component was already registered: {}", (Object)name);
                if (ci.canBeDuplicate()) {
                    return old;
                }
                throw new ServiceRuntimeException(ErrorCode.convert((String)"01-03002", (Object[])new Object[]{name}));
            }
            if (ci.resolve()) {
                this.typeRegistry(ci);
                ci.activate();
            }
        }
        catch (Throwable t) {
            ci.exception(new Exception(t));
            SofaLogger.error(ErrorCode.convert((String)"01-03004", (Object[])new Object[]{ci.getName()}), t);
        }
        return ci;
    }

    @Override
    public void unregister(ComponentInfo componentInfo) throws ServiceRuntimeException {
        ComponentName componentName = componentInfo.getName();
        this.registry.remove(componentName);
        if (componentName != null) {
            ComponentType componentType = componentName.getType();
            Map typesRi = (Map)this.resolvedRegistry.get(componentType);
            typesRi.remove(componentName);
        }
        componentInfo.unregister();
    }

    @Override
    public Collection<ComponentInfo> getComponentInfosByType(ComponentType type) {
        ArrayList<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        for (ComponentInfo componentInfo : this.registry.values()) {
            if (!type.equals(componentInfo.getType())) continue;
            componentInfos.add(componentInfo);
        }
        return componentInfos;
    }

    @Override
    public void resolvePendingResolveComponent(ComponentName componentName) {
        ComponentInfo componentInfo = (ComponentInfo)this.registry.get(componentName);
        if (componentInfo.isResolved()) {
            return;
        }
        if (componentInfo.resolve()) {
            this.typeRegistry(componentInfo);
            try {
                componentInfo.activate();
            }
            catch (Throwable t) {
                componentInfo.exception(new Exception(t));
                SofaLogger.error(ErrorCode.convert((String)"01-03005", (Object[])new Object[]{componentInfo.getName()}), t);
            }
        }
    }

    @Override
    public Collection<ComponentInfo> getComponentInfosByApplicationContext(ApplicationContext application) {
        ArrayList<ComponentInfo> componentInfos = new ArrayList<ComponentInfo>();
        for (ComponentInfo componentInfo : this.registry.values()) {
            if (!Objects.equals(application, componentInfo.getApplicationContext())) continue;
            componentInfos.add(componentInfo);
        }
        return componentInfos;
    }

    private void typeRegistry(ComponentInfo componentInfo) {
        ComponentName name = componentInfo.getName();
        if (name != null) {
            ComponentType type = name.getType();
            Map typesRi = (Map)this.resolvedRegistry.get(type);
            if (typesRi == null) {
                this.resolvedRegistry.putIfAbsent(type, new HashMap());
                typesRi = (Map)this.resolvedRegistry.get(type);
            }
            typesRi.put(name, componentInfo);
        }
    }
}

