/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime;

import com.alipay.sofa.ark.spi.event.biz.AfterBizStartupEvent;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.service.event.EventHandler;
import com.alipay.sofa.runtime.SofaFramework;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;

public class SofaBizHealthCheckEventHandler
implements EventHandler<AfterBizStartupEvent> {
    public void handleEvent(AfterBizStartupEvent event) {
        this.doHealthCheck((Biz)event.getSource());
    }

    private void doHealthCheck(Biz biz) {
        SofaRuntimeManager sofaRuntimeManager = this.getSofaRuntimeManager(biz);
        if (!sofaRuntimeManager.isReadinessHealth()) {
            throw new RuntimeException("Health check failed.");
        }
    }

    private SofaRuntimeManager getSofaRuntimeManager(Biz biz) {
        for (SofaRuntimeManager sofaRuntimeManager : SofaFramework.getRuntimeSet()) {
            if (!sofaRuntimeManager.getAppClassLoader().equals(biz.getBizClassLoader())) continue;
            return sofaRuntimeManager;
        }
        throw new RuntimeException("No SofaRuntimeManager Found!");
    }

    public int getPriority() {
        return 100;
    }
}

