/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.ext.spring.parser;

import com.alipay.sofa.boot.spring.namespace.spi.SofaBootTagNameSupport;
import com.alipay.sofa.runtime.ext.spring.ClassLoaderWrapper;
import com.alipay.sofa.runtime.ext.spring.parser.AbstractSingleExtPointBeanDefinitionParser;
import com.alipay.sofa.runtime.spi.util.ParserUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.core.io.Resource;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class AbstractExtBeanDefinitionParser
extends AbstractSingleExtPointBeanDefinitionParser
implements SofaBootTagNameSupport {
    public static final String REF = "ref";
    @Deprecated
    private static final String BEAN_CLASS_LOADER = "beanClassLoader";
    private static final String BEAN_CLASS_LOADER_WRAPPER = "beanClassLoaderWrapper";

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Resource res = parserContext.getReaderContext().getResource();
        builder.getBeanDefinition().setResource(res);
        builder.getRawBeanDefinition().setResource(res);
        this.configBeanClassLoader(parserContext, builder);
        this.parseAttribute(element, parserContext, builder);
        this.parserSubElement(element, parserContext, builder);
    }

    protected void configBeanClassLoader(ParserContext parserContext, BeanDefinitionBuilder builder) {
        ClassLoader beanClassLoader = parserContext.getReaderContext().getBeanClassLoader();
        builder.addPropertyValue(BEAN_CLASS_LOADER_WRAPPER, (Object)new ClassLoaderWrapper(beanClassLoader));
    }

    protected void parseAttribute(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ParserUtils.parseCustomAttributes(element, parserContext, builder, new ParserUtils.AttributeCallback(){

            @Override
            public void process(Element parent, Attr attribute, BeanDefinitionBuilder builder, ParserContext parserContext) {
                String name = attribute.getLocalName();
                if (!AbstractExtBeanDefinitionParser.REF.equals(name)) {
                    builder.addPropertyValue(Conventions.attributeNameToPropertyName((String)name), (Object)attribute.getValue());
                }
            }
        });
    }

    protected abstract void parserSubElement(Element var1, ParserContext var2, BeanDefinitionBuilder var3);

    @Override
    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

