/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.ext.spring;

import com.alipay.sofa.runtime.ext.component.ExtensionPointComponent;
import com.alipay.sofa.runtime.ext.spring.AbstractExtFactoryBean;
import com.alipay.sofa.runtime.ext.spring.ExtensionPointBuilder;
import com.alipay.sofa.runtime.log.SofaLogger;
import com.alipay.sofa.runtime.spi.spring.SpringImplementationImpl;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ExtensionPointFactoryBean
extends AbstractExtFactoryBean {
    private String name;
    private String[] contribution;

    @Override
    public void afterPropertiesSet() throws Exception {
        BeanDefinition beanDef;
        Class extensionPointClass;
        super.afterPropertiesSet();
        Assert.notNull((Object)this.beanFactory, (String)"required property 'beanFactory' has not been set");
        Assert.notNull((Object)this.name, (String)"required property 'name' has not been set for extension point");
        if (!StringUtils.hasText((String)this.targetBeanName) && this.target == null || StringUtils.hasText((String)this.targetBeanName) && this.target != null) {
            throw new IllegalArgumentException("either 'target' or 'targetBeanName' have to be specified");
        }
        Class clazz = extensionPointClass = this.target != null ? this.target.getClass() : this.beanFactory.getType(this.targetBeanName);
        if (StringUtils.hasText((String)this.targetBeanName) && this.beanFactory instanceof ConfigurableListableBeanFactory && (beanDef = ((ConfigurableListableBeanFactory)this.beanFactory).getBeanDefinition(this.targetBeanName)).isSingleton() && !beanDef.isLazyInit()) {
            if (SofaLogger.isDebugEnabled()) {
                SofaLogger.debug("target bean [" + this.targetBeanName + "] is a non-lazy singleton; forcing initialization before publishing");
            }
            this.beanFactory.getBean(this.targetBeanName);
        }
        try {
            this.publishAsNuxeoExtensionPoint(extensionPointClass);
        }
        catch (Exception e) {
            SofaLogger.error("Failed to publish extension point.", e);
            throw e;
        }
    }

    private void publishAsNuxeoExtensionPoint(Class<?> beanClass) throws Exception {
        Assert.notNull(beanClass, (String)"Service must be implement!");
        ExtensionPointBuilder extensionPointBuilder = ExtensionPointBuilder.genericExtensionPoint(this.name, this.applicationContext.getClassLoader());
        if (this.contribution != null && this.contribution.length != 0) {
            for (int i = 0; i < this.contribution.length; ++i) {
                extensionPointBuilder.addContribution(this.contribution[i]);
            }
        }
        Assert.hasLength((String)this.beanName, (String)"required property 'beanName' has not been set for creating implementation");
        Assert.notNull((Object)this.applicationContext, (String)"required property 'applicationContext' has not been set for creating implementation");
        SpringImplementationImpl implementation = new SpringImplementationImpl(this.targetBeanName, this.applicationContext);
        ExtensionPointComponent extensionPointComponent = new ExtensionPointComponent(extensionPointBuilder.getExtensionPoint(), this.sofaRuntimeContext, implementation);
        extensionPointComponent.setApplicationContext(this.applicationContext);
        this.sofaRuntimeContext.getComponentManager().register(extensionPointComponent);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setContribution(String[] contribution) throws Exception {
        this.contribution = contribution;
    }

    public String toString() {
        return "ExtensionPointTarget: " + this.targetBeanName;
    }
}

