/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spring;

import com.alipay.sofa.runtime.annotation.PlaceHolderAnnotationInvocationHandler;
import com.alipay.sofa.runtime.annotation.PlaceHolderBinder;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.annotation.SofaReference;
import com.alipay.sofa.runtime.api.annotation.SofaReferenceBinding;
import com.alipay.sofa.runtime.api.annotation.SofaService;
import com.alipay.sofa.runtime.api.annotation.SofaServiceBinding;
import com.alipay.sofa.runtime.api.binding.BindingType;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.log.SofaLogger;
import com.alipay.sofa.runtime.spi.service.BindingConverter;
import com.alipay.sofa.runtime.spi.service.BindingConverterContext;
import com.alipay.sofa.runtime.spi.service.BindingConverterFactory;
import com.alipay.sofa.runtime.spring.bean.SofaBeanNameGenerator;
import com.alipay.sofa.runtime.spring.factory.ReferenceFactoryBean;
import com.alipay.sofa.runtime.spring.factory.ServiceFactoryBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ServiceBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private final PlaceHolderBinder binder = new DefaultPlaceHolderBinder();
    private ConfigurableApplicationContext applicationContext;
    private SofaRuntimeContext sofaRuntimeContext;
    private BindingConverterFactory bindingConverterFactory;
    private ConfigurableEnvironment environment;

    public ServiceBeanFactoryPostProcessor(ConfigurableApplicationContext applicationContext, SofaRuntimeContext sofaRuntimeContext, BindingConverterFactory bindingConverterFactory) {
        this.applicationContext = applicationContext;
        this.sofaRuntimeContext = sofaRuntimeContext;
        this.bindingConverterFactory = bindingConverterFactory;
        this.environment = applicationContext.getEnvironment();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Arrays.stream(beanFactory.getBeanDefinitionNames()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(arg_0))).forEach((key, value) -> this.transformSofaBeanDefinition((String)key, (BeanDefinition)value, beanFactory));
    }

    private void transformSofaBeanDefinition(String beanId, BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
        if (this.isFromConfigurationSource(beanDefinition)) {
            this.generateSofaServiceDefinitionOnMethod(beanId, (AnnotatedBeanDefinition)beanDefinition, beanFactory);
        } else {
            Class<?> beanClassType = this.resolveBeanClassType(beanDefinition);
            if (beanClassType == null) {
                SofaLogger.warn("Bean class type cant be resolved from bean of {0}", beanId);
                return;
            }
            this.generateSofaServiceDefinitionOnClass(beanId, beanClassType, beanDefinition, beanFactory);
        }
    }

    private void generateSofaServiceDefinitionOnMethod(String beanId, AnnotatedBeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
        Class declaringClass;
        Class returnType;
        ArrayList<Method> candidateMethods = new ArrayList<Method>();
        MethodMetadata methodMetadata = beanDefinition.getFactoryMethodMetadata();
        try {
            returnType = ClassUtils.forName((String)methodMetadata.getReturnTypeName(), null);
            declaringClass = ClassUtils.forName((String)methodMetadata.getDeclaringClassName(), null);
        }
        catch (Throwable throwable) {
            SofaLogger.error(throwable, "Failed to parse factoryBeanMethod of BeanDefinition( {0} )", beanId);
            return;
        }
        if (methodMetadata instanceof StandardMethodMetadata) {
            candidateMethods.add(((StandardMethodMetadata)methodMetadata).getIntrospectedMethod());
        } else {
            for (Method m : declaringClass.getDeclaredMethods()) {
                if (!m.getName().equals(methodMetadata.getMethodName()) || !m.getReturnType().getTypeName().equals(methodMetadata.getReturnTypeName()) || !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)m, Bean.class)) continue;
                Bean bean = m.getAnnotation(Bean.class);
                HashSet<String> beanNames = new HashSet<String>();
                beanNames.add(m.getName());
                if (bean != null) {
                    beanNames.addAll(Arrays.asList(bean.name()));
                    beanNames.addAll(Arrays.asList(bean.value()));
                }
                if (!beanNames.contains(beanId)) continue;
                candidateMethods.add(m);
            }
        }
        if (candidateMethods.size() == 1) {
            SofaService sofaServiceAnnotation = ((Method)candidateMethods.get(0)).getAnnotation(SofaService.class);
            if (sofaServiceAnnotation == null) {
                sofaServiceAnnotation = returnType.getAnnotation(SofaService.class);
            }
            this.generateSofaServiceDefinition(beanId, sofaServiceAnnotation, returnType, (BeanDefinition)beanDefinition, beanFactory);
            this.generateSofaReferenceDefinition(beanId, (Method)candidateMethods.get(0), beanFactory);
        } else if (candidateMethods.size() > 1) {
            for (Method m : candidateMethods) {
                if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)m, SofaService.class) || AnnotatedElementUtils.hasAnnotation((AnnotatedElement)returnType, SofaService.class)) {
                    throw new FatalBeanException("multi @Bean-method with same name try to publish SofaService in " + declaringClass.getCanonicalName());
                }
                if (!Stream.of(m.getParameterAnnotations()).flatMap(Stream::of).anyMatch(annotation -> annotation instanceof SofaReference)) continue;
                throw new FatalBeanException("multi @Bean-method with same name try to reference SofaService in" + declaringClass.getCanonicalName());
            }
        }
    }

    private void generateSofaReferenceDefinition(String beanId, Method method, ConfigurableListableBeanFactory beanFactory) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof SofaReference)) continue;
                this.doGenerateSofaReferenceDefinition(beanFactory.getBeanDefinition(beanId), (SofaReference)annotation, parameterTypes[i], beanFactory);
            }
        }
    }

    private void doGenerateSofaReferenceDefinition(BeanDefinition beanDefinition, SofaReference sofaReference, Class<?> parameterType, ConfigurableListableBeanFactory beanFactory) {
        String uniqueId;
        String referenceId;
        Assert.isTrue((boolean)JvmBinding.JVM_BINDING_TYPE.getType().equals(sofaReference.binding().bindingType()), (String)"Only jvm type of @SofaReference on parameter is supported.");
        PlaceHolderAnnotationInvocationHandler.AnnotationWrapperBuilder wrapperBuilder = PlaceHolderAnnotationInvocationHandler.AnnotationWrapperBuilder.wrap(sofaReference).withBinder(this.binder);
        sofaReference = (SofaReference)wrapperBuilder.build();
        Class<?> interfaceType = sofaReference.interfaceType();
        if (interfaceType.equals(Void.TYPE)) {
            interfaceType = parameterType;
        }
        if (!beanFactory.containsBeanDefinition(referenceId = SofaBeanNameGenerator.generateSofaReferenceBeanName(interfaceType, uniqueId = sofaReference.uniqueId()))) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
            builder.getRawBeanDefinition().setScope(beanDefinition.getScope());
            builder.getRawBeanDefinition().setLazyInit(beanDefinition.isLazyInit());
            builder.getRawBeanDefinition().setBeanClass(ReferenceFactoryBean.class);
            builder.addPropertyValue("uniqueId", (Object)uniqueId);
            builder.addPropertyValue("interfaceClass", interfaceType);
            builder.addPropertyValue("bindings", this.getSofaReferenceBinding(sofaReference, sofaReference.binding()));
            builder.addPropertyValue("apiType", (Object)true);
            ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(referenceId, (BeanDefinition)builder.getBeanDefinition());
        }
        if (beanDefinition.getDependsOn() == null) {
            beanDefinition.setDependsOn(new String[]{referenceId});
        } else {
            String[] added = (String[])ObjectUtils.addObjectToArray((Object[])beanDefinition.getDependsOn(), (Object)referenceId);
            beanDefinition.setDependsOn(added);
        }
    }

    private void generateSofaServiceDefinitionOnClass(String beanId, Class<?> beanClass, BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
        SofaService sofaServiceAnnotation = beanClass.getAnnotation(SofaService.class);
        this.generateSofaServiceDefinition(beanId, sofaServiceAnnotation, beanClass, beanDefinition, beanFactory);
    }

    private void generateSofaServiceDefinition(String beanId, SofaService sofaServiceAnnotation, Class<?> beanClass, BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
        if (sofaServiceAnnotation == null) {
            return;
        }
        PlaceHolderAnnotationInvocationHandler.AnnotationWrapperBuilder wrapperBuilder = PlaceHolderAnnotationInvocationHandler.AnnotationWrapperBuilder.wrap(sofaServiceAnnotation).withBinder(this.binder);
        Class<?> interfaceType = (sofaServiceAnnotation = (SofaService)wrapperBuilder.build()).interfaceType();
        if (interfaceType.equals(Void.TYPE)) {
            Class<?>[] interfaces = beanClass.getInterfaces();
            if (beanClass.isInterface() || interfaces == null || interfaces.length == 0) {
                interfaceType = beanClass;
            } else if (interfaces.length == 1) {
                interfaceType = interfaces[0];
            } else {
                throw new FatalBeanException("Bean " + beanId + " has more than one interface.");
            }
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
        String serviceId = SofaBeanNameGenerator.generateSofaServiceBeanName(interfaceType, sofaServiceAnnotation.uniqueId());
        if (!beanFactory.containsBeanDefinition(serviceId)) {
            builder.getRawBeanDefinition().setScope(beanDefinition.getScope());
            builder.setLazyInit(beanDefinition.isLazyInit());
            builder.getRawBeanDefinition().setBeanClass(ServiceFactoryBean.class);
            builder.addPropertyValue("interfaceClass", interfaceType);
            builder.addPropertyValue("uniqueId", (Object)sofaServiceAnnotation.uniqueId());
            builder.addPropertyValue("bindings", this.getSofaServiceBinding(sofaServiceAnnotation, sofaServiceAnnotation.bindings()));
            builder.addPropertyReference("ref", beanId);
            builder.addPropertyValue("beanId", (Object)beanId);
            builder.addPropertyValue("apiType", (Object)true);
            builder.addDependsOn(beanId);
            ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(serviceId, (BeanDefinition)builder.getBeanDefinition());
        } else {
            SofaLogger.error("SofaService was already registered: {0}", serviceId);
        }
    }

    private List<Binding> getSofaServiceBinding(SofaService sofaServiceAnnotation, SofaServiceBinding[] sofaServiceBindings) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (SofaServiceBinding sofaServiceBinding : sofaServiceBindings) {
            BindingConverter bindingConverter = this.bindingConverterFactory.getBindingConverter(new BindingType(sofaServiceBinding.bindingType()));
            if (bindingConverter == null) {
                throw new ServiceRuntimeException("Can not found binding converter for binding type " + sofaServiceBinding.bindingType());
            }
            BindingConverterContext bindingConverterContext = new BindingConverterContext();
            bindingConverterContext.setInBinding(false);
            bindingConverterContext.setApplicationContext((ApplicationContext)this.applicationContext);
            bindingConverterContext.setAppName(this.sofaRuntimeContext.getAppName());
            bindingConverterContext.setAppClassLoader(this.sofaRuntimeContext.getAppClassLoader());
            Object binding = bindingConverter.convert(sofaServiceAnnotation, sofaServiceBinding, bindingConverterContext);
            bindings.add((Binding)binding);
        }
        return bindings;
    }

    private List<Binding> getSofaReferenceBinding(SofaReference sofaReferenceAnnotation, SofaReferenceBinding sofaReferenceBinding) {
        if (!JvmBinding.XmlConstants.BINDING_TYPE.equals(sofaReferenceBinding.bindingType())) {
            throw new ServiceRuntimeException("Only jvm sofa reference binding is supported to annotate on parameter.");
        }
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        BindingConverter bindingConverter = this.bindingConverterFactory.getBindingConverter(new BindingType(sofaReferenceBinding.bindingType()));
        if (bindingConverter == null) {
            throw new ServiceRuntimeException("Can not found binding converter for binding type " + sofaReferenceBinding.bindingType());
        }
        BindingConverterContext bindingConverterContext = new BindingConverterContext();
        bindingConverterContext.setInBinding(true);
        bindingConverterContext.setApplicationContext((ApplicationContext)this.applicationContext);
        bindingConverterContext.setAppName(this.sofaRuntimeContext.getAppName());
        bindingConverterContext.setAppClassLoader(this.sofaRuntimeContext.getAppClassLoader());
        Object binding = bindingConverter.convert(sofaReferenceAnnotation, sofaReferenceBinding, bindingConverterContext);
        bindings.add((Binding)binding);
        return bindings;
    }

    private boolean isFromConfigurationSource(BeanDefinition beanDefinition) {
        return beanDefinition.getClass().getCanonicalName().startsWith("org.springframework.context.annotation.ConfigurationClassBeanDefinitionReader");
    }

    private Class<?> resolveBeanClassType(BeanDefinition beanDefinition) {
        String className2;
        Class clazz = null;
        if (beanDefinition instanceof AnnotatedBeanDefinition) {
            AnnotationMetadata annotationMetadata = ((AnnotatedBeanDefinition)beanDefinition).getMetadata();
            try {
                className2 = annotationMetadata.getClassName();
                clazz = StringUtils.isEmpty((Object)className2) ? null : ClassUtils.forName((String)className2, null);
            }
            catch (Throwable className2) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                clazz = ((AbstractBeanDefinition)beanDefinition).getBeanClass();
            }
            catch (IllegalStateException ex) {
                try {
                    className2 = beanDefinition.getBeanClassName();
                    clazz = StringUtils.isEmpty((Object)className2) ? null : ClassUtils.forName((String)className2, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (ClassUtils.isCglibProxyClass(clazz)) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    class DefaultPlaceHolderBinder
    implements PlaceHolderBinder {
        DefaultPlaceHolderBinder() {
        }

        @Override
        public String bind(String text) {
            return ServiceBeanFactoryPostProcessor.this.environment.resolvePlaceholders(text);
        }
    }
}

