/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.spi.component;

import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.component.ComponentName;
import com.alipay.sofa.runtime.model.ComponentStatus;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.Implementation;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.health.HealthResult;

public abstract class AbstractComponent
implements ComponentInfo {
    protected ComponentStatus componentStatus = ComponentStatus.UNREGISTERED;
    protected Implementation implementation;
    protected ComponentName componentName;
    protected SofaRuntimeContext sofaRuntimeContext;
    protected Exception e;

    @Override
    public SofaRuntimeContext getContext() {
        return this.sofaRuntimeContext;
    }

    @Override
    public ComponentStatus getState() {
        return this.componentStatus;
    }

    @Override
    public ComponentName getName() {
        return this.componentName;
    }

    @Override
    public Implementation getImplementation() {
        return this.implementation;
    }

    @Override
    public boolean isActivated() {
        return this.componentStatus == ComponentStatus.ACTIVATED;
    }

    @Override
    public boolean isResolved() {
        return this.componentStatus == ComponentStatus.ACTIVATED || this.componentStatus == ComponentStatus.RESOLVED;
    }

    @Override
    public void register() {
        if (this.componentStatus != ComponentStatus.UNREGISTERED) {
            return;
        }
        this.componentStatus = ComponentStatus.REGISTERED;
    }

    @Override
    public void unregister() throws ServiceRuntimeException {
        if (this.componentStatus == ComponentStatus.UNREGISTERED) {
            return;
        }
        if (this.componentStatus == ComponentStatus.ACTIVATED || this.componentStatus == ComponentStatus.RESOLVED) {
            this.unresolve();
        }
        this.componentStatus = ComponentStatus.UNREGISTERED;
    }

    @Override
    public void unresolve() throws ServiceRuntimeException {
        if (this.componentStatus == ComponentStatus.REGISTERED || this.componentStatus == ComponentStatus.UNREGISTERED) {
            return;
        }
        if (this.componentStatus == ComponentStatus.ACTIVATED) {
            this.deactivate();
        }
        this.componentStatus = ComponentStatus.REGISTERED;
    }

    @Override
    public boolean resolve() {
        if (this.componentStatus != ComponentStatus.REGISTERED) {
            return false;
        }
        this.componentStatus = ComponentStatus.RESOLVED;
        return true;
    }

    @Override
    public void activate() throws ServiceRuntimeException {
        if (this.componentStatus != ComponentStatus.RESOLVED) {
            return;
        }
        this.componentStatus = ComponentStatus.ACTIVATED;
    }

    @Override
    public void exception(Exception e) throws ServiceRuntimeException {
        this.e = e;
    }

    @Override
    public void deactivate() throws ServiceRuntimeException {
        if (this.componentStatus != ComponentStatus.ACTIVATED) {
            return;
        }
        this.componentStatus = ComponentStatus.RESOLVED;
    }

    @Override
    public String dump() {
        return this.componentName.getRawName();
    }

    @Override
    public HealthResult isHealthy() {
        HealthResult healthResult = new HealthResult(this.componentName.getRawName());
        if (!this.isActivated()) {
            healthResult.setHealthy(false);
            healthResult.setHealthReport("Status: " + this.getState().toString());
        } else {
            healthResult.setHealthy(true);
        }
        return healthResult;
    }

    @Override
    public boolean canBeDuplicate() {
        return true;
    }
}

