/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.component.impl;

import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.api.event.ApplicationShutdownCallback;
import com.alipay.sofa.runtime.component.impl.ComponentManagerImpl;
import com.alipay.sofa.runtime.spi.client.ClientFactoryInternal;
import com.alipay.sofa.runtime.spi.component.ComponentManager;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;
import com.alipay.sofa.runtime.spi.health.RuntimeHealthChecker;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class StandardSofaRuntimeManager
implements SofaRuntimeManager {
    private ComponentManager componentManager;
    private ClientFactoryInternal clientFactoryInternal;
    private SofaRuntimeContext sofaRuntimeContext;
    private String appName;
    private ClassLoader appClassLoader;
    private List<ApplicationShutdownCallback> applicationShutdownCallbacks = new CopyOnWriteArrayList<ApplicationShutdownCallback>();
    private List<RuntimeHealthChecker> runtimeHealthCheckers = new CopyOnWriteArrayList<RuntimeHealthChecker>();

    public StandardSofaRuntimeManager(String appName, ClassLoader appClassLoader, ClientFactoryInternal clientFactoryInternal) {
        this.componentManager = new ComponentManagerImpl(clientFactoryInternal);
        this.appName = appName;
        this.appClassLoader = appClassLoader;
        this.sofaRuntimeContext = new SofaRuntimeContext(this, this.componentManager, clientFactoryInternal);
        this.clientFactoryInternal = clientFactoryInternal;
    }

    @Override
    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Override
    public ClientFactoryInternal getClientFactoryInternal() {
        return this.clientFactoryInternal;
    }

    @Override
    public boolean isHealthCheckPassed() {
        for (RuntimeHealthChecker runtimeHealthChecker : this.runtimeHealthCheckers) {
            if (runtimeHealthChecker.isHealth()) continue;
            return false;
        }
        return true;
    }

    @Override
    public SofaRuntimeContext getSofaRuntimeContext() {
        return this.sofaRuntimeContext;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public ClassLoader getAppClassLoader() {
        return this.appClassLoader;
    }

    @Override
    public void shutdown() throws ServiceRuntimeException {
        try {
            for (ApplicationShutdownCallback callback : this.applicationShutdownCallbacks) {
                callback.shutdown();
            }
            if (this.componentManager != null) {
                this.componentManager.shutdown();
            }
            this.clear();
        }
        catch (Throwable throwable) {
            throw new ServiceRuntimeException(throwable);
        }
    }

    @Override
    public void registerShutdownCallback(ApplicationShutdownCallback callback) {
        this.applicationShutdownCallbacks.add(callback);
    }

    @Override
    public void registerRuntimeHealthChecker(RuntimeHealthChecker runtimeHealthChecker) {
        this.runtimeHealthCheckers.add(runtimeHealthChecker);
    }

    protected void clear() {
        this.componentManager = null;
        this.sofaRuntimeContext = null;
        this.clientFactoryInternal = null;
        this.appClassLoader = null;
        this.applicationShutdownCallbacks = null;
    }
}

