/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.util;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolExecutorDataServer
extends ThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolExecutorDataServer.class);
    private String executorName;

    public ThreadPoolExecutorDataServer(String executorName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.executorName = executorName;
    }

    @Override
    public String toString() {
        return super.toString() + this.executorName;
    }

    @Override
    public void execute(Runnable command) {
        try {
            super.execute(command);
        }
        catch (RejectedExecutionException e) {
            LOGGER.error("Processor session executor {} Rejected Execution!command {}", new Object[]{this, command.getClass(), e});
        }
    }
}

