/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.data.remoting.dataserver;

import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.CallbackHandler;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.server.data.remoting.DataNodeExchanger;
import com.alipay.sofa.registry.server.data.remoting.dataserver.SyncDataCallback;
import org.springframework.beans.factory.annotation.Autowired;

public class GetSyncDataHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetSyncDataHandler.class);
    @Autowired
    private DataNodeExchanger dataNodeExchanger;

    public void syncData(final SyncDataCallback callback) {
        int tryCount = callback.getRetryCount();
        if (tryCount > 0) {
            try {
                callback.setRetryCount(--tryCount);
                this.dataNodeExchanger.request(new Request(){

                    public Object getRequestBody() {
                        return callback.getRequest();
                    }

                    public URL getRequestUrl() {
                        return new URL(callback.getConnection().getRemoteIP(), callback.getConnection().getRemotePort());
                    }

                    public CallbackHandler getCallBackHandler() {
                        return new CallbackHandler(){

                            public void onCallback(Channel channel, Object message) {
                                callback.onResponse(message);
                            }

                            public void onException(Channel channel, Throwable exception) {
                                callback.onException(exception);
                            }
                        };
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("[GetSyncDataHandler] send sync data request failed", (Throwable)e);
            }
        } else {
            LOGGER.info("[GetSyncDataHandler] sync data retry for three times");
        }
    }
}

