/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.thread;

import com.alipay.sofa.common.thread.ExecutingRunnable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadPoolStatistics {
    private final ThreadPoolExecutor threadPoolExecutor;
    private final Map<ExecutingRunnable, Long> executingTasks = new ConcurrentHashMap<ExecutingRunnable, Long>();
    AtomicLong totalRunningTime = new AtomicLong();
    AtomicLong totalStayInQueueTime = new AtomicLong();
    AtomicLong totalTaskCount = new AtomicLong();

    public ThreadPoolStatistics(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public Map<ExecutingRunnable, Long> getExecutingTasks() {
        return this.executingTasks;
    }

    public long getQueueSize() {
        return this.threadPoolExecutor.getQueue().size();
    }

    public long getPoolSize() {
        return this.threadPoolExecutor.getPoolSize();
    }

    public void addTotalRunningTime(long runningTime) {
        this.totalRunningTime.addAndGet(runningTime);
    }

    public void addTotalStayInQueueTime(long stayInQueueTime) {
        this.totalStayInQueueTime.addAndGet(stayInQueueTime);
    }

    public void addTotalTaskCount() {
        this.totalTaskCount.incrementAndGet();
    }

    public long getTotalTaskCount() {
        return this.totalTaskCount.get();
    }

    public long getAverageRunningTime() {
        return this.totalTaskCount.get() == 0L ? -1L : this.totalRunningTime.get() / this.totalTaskCount.get();
    }

    public long getAverageStayInQueueTime() {
        return this.totalTaskCount.get() == 0L ? -1L : this.totalStayInQueueTime.get() / this.totalTaskCount.get();
    }

    public void resetAverageStatics() {
        this.totalTaskCount.set(0L);
        this.totalRunningTime.set(0L);
        this.totalStayInQueueTime.set(0L);
    }
}

