/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log;

import com.alipay.sofa.common.utils.StringUtil;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CommonLoggingConfigurations {
    private static final Set<String> LOGGER_CONSOLE_WHITE_SET = ConcurrentHashMap.newKeySet();
    private static final Set<String> LOGGER_CONSOLE_PREFIX_WHITE_SET = ConcurrentHashMap.newKeySet();
    private static final Map<String, String> EXTERNAL_CONFIGURATIONS = new ConcurrentHashMap<String, String>();

    public static void loadExternalConfiguration(String key, String value) {
        if (StringUtil.isNotEmpty(key) && StringUtil.isNotEmpty(value)) {
            EXTERNAL_CONFIGURATIONS.put(key, value);
        }
    }

    public static Map<String, String> getExternalConfigurations() {
        return EXTERNAL_CONFIGURATIONS;
    }

    public static void appendConsoleLoggerName(String loggerName) {
        LOGGER_CONSOLE_WHITE_SET.add(loggerName);
    }

    public static void appendConsolePrefixWhiteLoggerName(String loggerName) {
        LOGGER_CONSOLE_PREFIX_WHITE_SET.add(loggerName);
    }

    public static void addAllConsoleLogger(Set<String> set) {
        LOGGER_CONSOLE_WHITE_SET.addAll(set);
    }

    public static void addAllConsolePrefixWhiteLoggerName(Set<String> set) {
        LOGGER_CONSOLE_PREFIX_WHITE_SET.addAll(set);
    }

    public static Set<String> getLoggerConsoleWhiteSet() {
        return LOGGER_CONSOLE_WHITE_SET;
    }

    public static Set<String> getLoggerConsolePrefixWhiteSet() {
        return LOGGER_CONSOLE_PREFIX_WHITE_SET;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldAttachConsoleAppender(String loggerName) {
        if (LOGGER_CONSOLE_WHITE_SET.contains(loggerName)) return true;
        if (!LOGGER_CONSOLE_PREFIX_WHITE_SET.stream().anyMatch(loggerName::startsWith)) return false;
        return true;
    }

    public static void clearLoggerConsoleProperties() {
        LOGGER_CONSOLE_WHITE_SET.clear();
        LOGGER_CONSOLE_PREFIX_WHITE_SET.clear();
    }
}

