/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.config.listener;

import com.alipay.sofa.common.config.ConfigKey;
import com.alipay.sofa.common.config.ConfigSource;
import com.alipay.sofa.common.config.listener.AbstractConfigListener;
import com.alipay.sofa.common.config.log.ConfigLoggerFactory;
import java.util.List;
import org.slf4j.Logger;

public class LogConfigListener
extends AbstractConfigListener {
    private static final Logger LOGGER = ConfigLoggerFactory.CONFIG_COMMON_DIGEST_LOGGER;

    @Override
    public void afterConfigLoaded(ConfigKey configKey, ConfigSource configSource, List<ConfigSource> configSourceList) {
        String keyStr = configKey.getKey();
        String configName = configSource.getName();
        String value = configSource.getStringConfig(configKey);
        String effectKey = configSource.getEffectiveKey(configKey);
        LOGGER.info("Load {} from {} ,effect key is {}, value is \"{}\"", new Object[]{keyStr, configName, effectKey, value});
    }

    @Override
    public void onLoadDefaultValue(ConfigKey key, Object defaultValue) {
        if (key.getDefaultValue().equals(defaultValue)) {
            LOGGER.info("Load {} according defaultValue ,default value is \"{}\"", (Object)key.getKey(), defaultValue);
        } else {
            LOGGER.warn("Config {}'s defaultValue {} does not equals to actually defaultValue {}", new Object[]{key, key.getDefaultValue(), defaultValue});
        }
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

