/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.factory;

import com.alipay.sofa.common.log.CommonLoggingConfigurations;
import com.alipay.sofa.common.log.LogSpace;
import com.alipay.sofa.common.log.env.LogEnvUtils;
import com.alipay.sofa.common.log.factory.AbstractLoggerSpaceFactory;
import com.alipay.sofa.common.log.factory.LoggerSpaceFactoryBuilder;
import com.alipay.sofa.common.space.SpaceId;
import com.alipay.sofa.common.utils.AssertUtil;
import com.alipay.sofa.common.utils.ReportUtil;
import com.alipay.sofa.common.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public abstract class AbstractLoggerSpaceFactoryBuilder
implements LoggerSpaceFactoryBuilder {
    private SpaceId spaceId;
    private LogSpace logSpace;
    private String spaceDirectoryPrefix;

    public AbstractLoggerSpaceFactoryBuilder(SpaceId spaceId, LogSpace space) {
        AssertUtil.notNull(space);
        AssertUtil.notNull(spaceId);
        this.spaceId = spaceId;
        this.logSpace = space;
        this.spaceDirectoryPrefix = spaceId.getSpaceName().replace('.', '/') + "/" + "log" + "/" + this.getLoggingToolName() + "/";
    }

    @Override
    public AbstractLoggerSpaceFactory build(String spaceName, ClassLoader spaceClassloader) {
        AssertUtil.hasText(spaceName);
        AssertUtil.notNull(spaceClassloader);
        URL configFileUrl = this.getSpaceLogConfigFileURL(spaceClassloader, spaceName);
        this.specifySpaceLogConfigProperties(spaceName);
        return this.doBuild(spaceName, spaceClassloader, configFileUrl);
    }

    private List<URL> getResources(ClassLoader classLoader, String path) {
        ArrayList<URL> rtn = new ArrayList<URL>();
        try {
            Enumeration<URL> allUrls = classLoader.getResources(path);
            if (allUrls != null) {
                while (allUrls.hasMoreElements()) {
                    rtn.add(allUrls.nextElement());
                }
            }
        }
        catch (IOException e) {
            ReportUtil.reportWarn("Fail to get resource of " + path + " from classpath", e);
            return null;
        }
        return rtn;
    }

    protected URL getSpaceLogConfigFileURL(ClassLoader spaceClassloader, String spaceName) {
        String loggingConfig = this.logSpace.getProperty(String.format("logging.config.%s", this.spaceId.getSpaceName()));
        if (StringUtil.isNotEmpty(loggingConfig)) {
            return spaceClassloader.getResource(loggingConfig);
        }
        String suffix = LogEnvUtils.getLogConfEnvSuffix(spaceName);
        String logConfigLocation = this.spaceDirectoryPrefix + "log-conf.xml" + suffix;
        String logConfigPropertyLocation = this.spaceDirectoryPrefix + "config.properties" + suffix;
        URL configFileUrl = null;
        List<URL> logConfigFileUrls = this.getResources(spaceClassloader, logConfigLocation);
        List<URL> logConfigPropertyFileUrls = this.getResources(spaceClassloader, logConfigPropertyLocation);
        try {
            configFileUrl = this.getResourceByPriority(logConfigFileUrls, logConfigPropertyFileUrls);
            if (configFileUrl == null && StringUtil.isNotEmpty(suffix)) {
                logConfigLocation = this.spaceDirectoryPrefix + String.format("log-conf-%s.xml", suffix.substring(1));
                configFileUrl = spaceClassloader.getResource(logConfigLocation);
            }
        }
        catch (Exception e) {
            ReportUtil.reportError("Error when get resources of " + spaceName + " from classpath.", e);
        }
        AssertUtil.state(configFileUrl != null, this + " build error: No " + this.getLoggingToolName() + " config file (" + configFileUrl + ") found!");
        return configFileUrl;
    }

    @Deprecated
    protected URL getResource(ClassLoader spaceClassloader, List<URL> logConfigFileUrls, List<URL> configPropertyFileUrls) throws IOException {
        return this.getResourceByPriority(logConfigFileUrls, configPropertyFileUrls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getResourceByPriority(List<URL> logConfigFileUrls, List<URL> logConfigPropertyFileUrls) throws IOException {
        if (logConfigFileUrls == null || logConfigFileUrls.isEmpty()) {
            return null;
        }
        ArrayList<ConfigFile> configFiles = new ArrayList<ConfigFile>();
        for (URL logConfigUrl : logConfigFileUrls) {
            int priority = 0;
            if (logConfigPropertyFileUrls != null) {
                for (URL configPropertyUrl : logConfigPropertyFileUrls) {
                    String absoluteLogPath;
                    String absoluteConfigPath = new File(configPropertyUrl.getFile()).getParentFile().getAbsolutePath();
                    if (!absoluteConfigPath.equals(absoluteLogPath = new File(logConfigUrl.getFile()).getParentFile().getAbsolutePath())) continue;
                    try (InputStream inputStream = null;){
                        String loggerConsoleWhiteSetStr;
                        URLConnection uConn = configPropertyUrl.openConnection();
                        uConn.setUseCaches(false);
                        inputStream = uConn.getInputStream();
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        String priorityStr = properties.getProperty("priority");
                        if (StringUtil.isNotEmpty(priorityStr)) {
                            priority = Integer.parseInt(priorityStr);
                        }
                        if (!StringUtil.isNotEmpty(loggerConsoleWhiteSetStr = properties.getProperty("console"))) break;
                        for (String logger : loggerConsoleWhiteSetStr.split(",")) {
                            CommonLoggingConfigurations.appendConsoleLoggerName(logger);
                        }
                        break;
                    }
                }
            }
            ConfigFile configFile = new ConfigFile(priority, logConfigUrl);
            ReportUtil.reportDebug("Find URL " + logConfigUrl + ", priority is " + priority);
            configFiles.add(configFile);
        }
        configFiles.sort((o1, o2) -> -Integer.compare(o1.priority, o2.priority));
        return ((ConfigFile)configFiles.get((int)0)).url;
    }

    private void specifySpaceLogConfigProperties(String spaceName) {
        String loggingLevelKey;
        String loggingPathKey = "logging.path." + spaceName;
        String defaultLoggingPath = this.logSpace.getProperty("logging.path");
        if (this.logSpace.getProperty(loggingPathKey) == null) {
            this.logSpace.setProperty("isDefaultLogPath", Boolean.TRUE.toString());
            this.logSpace.setProperty(loggingPathKey, defaultLoggingPath);
        }
        if (this.logSpace.getProperty(loggingLevelKey = "logging.level." + spaceName) == null) {
            this.logSpace.setProperty("isDefaultLogLevel", Boolean.TRUE.toString());
            this.logSpace.setProperty(loggingLevelKey, "INFO");
            for (int i = "logging.level".length(); i < loggingLevelKey.length(); ++i) {
                String level;
                if (loggingLevelKey.charAt(i) != '.' || StringUtil.isBlank(level = this.logSpace.getProperty(loggingLevelKey.substring(0, i + 1) + "*"))) continue;
                this.logSpace.setProperty(loggingLevelKey, level);
            }
        }
    }

    protected abstract AbstractLoggerSpaceFactory doBuild(String var1, ClassLoader var2, URL var3);

    protected abstract String getLoggingToolName();

    protected SpaceId getSpaceId() {
        return this.spaceId;
    }

    protected Properties getProperties() {
        return this.logSpace.properties();
    }

    private static class ConfigFile {
        final int priority;
        final URL url;

        ConfigFile(int priority, URL url) {
            this.priority = priority;
            this.url = url;
        }
    }
}

