/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.kernel;

import com.alipay.easysdk.kernel.CertEnvironment;
import com.alipay.easysdk.kernel.Config;
import com.alipay.easysdk.kernel.util.Signer;
import com.aliyun.tea.TeaModel;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;

public class Context {
    private final Map<String, Object> config;
    private String sdkVersion;
    private CertEnvironment certEnvironment;
    private Signer signer;

    public Context(Config options, String sdkVersion) throws Exception {
        this.config = TeaModel.buildMap((TeaModel)options);
        this.sdkVersion = sdkVersion;
        Preconditions.checkArgument((boolean)"RSA2".equals(this.getConfig("signType")), (Object)"Alipay Easy SDK\u53ea\u5141\u8bb8\u4f7f\u7528RSA2\u7b7e\u540d\u65b9\u5f0f\uff0cRSA\u7b7e\u540d\u65b9\u5f0f\u7531\u4e8e\u5b89\u5168\u6027\u76f8\u6bd4RSA2\u5f31\u5df2\u4e0d\u518d\u63a8\u8350\u3002");
        if (!Strings.isNullOrEmpty((String)this.getConfig("alipayCertPath"))) {
            this.certEnvironment = new CertEnvironment(this.getConfig("merchantCertPath"), this.getConfig("alipayCertPath"), this.getConfig("alipayRootCertPath"));
        }
        this.signer = new Signer();
    }

    public String getConfig(String key) {
        return (String)this.config.get(key);
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public CertEnvironment getCertEnvironment() {
        return this.certEnvironment;
    }

    public Signer getSigner() {
        return this.signer;
    }

    public void setSigner(Signer signer) {
        this.signer = signer;
    }
}

