/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.service.schema.model.attribute;

import com.alipay.service.schema.exception.ServiceSchemaException;
import com.alipay.service.schema.model.attribute.Attribute;
import com.alipay.service.schema.model.enums.SchemaErrorEnum;
import com.alipay.service.schema.util.StringUtil;
import com.alipay.service.schema.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class ComplexAttribute
extends Attribute {
    private List<Attribute> attributes = new ArrayList<Attribute>();

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    @Override
    public Element toElement() throws ServiceSchemaException {
        Element attributeNode = XmlUtils.createRootElement("attribute");
        if (StringUtil.isEmpty(this.getId())) {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_MISS_ID);
        }
        if (this.getType() == null || StringUtil.isEmpty(this.getType().getType())) {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_MISS_TYPE, this.getId());
        }
        if (this.getType() == null) {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_TYPE_ERROR, this.getId());
        }
        attributeNode.addAttribute("id", this.getId());
        attributeNode.addAttribute("name", this.getName());
        attributeNode.addAttribute("type", this.getType().getType());
        attributeNode.addAttribute("valueType", this.getValueType().getCode());
        Element attributesElm = XmlUtils.appendElement(attributeNode, "attributes");
        for (Attribute attribute : this.attributes) {
            Element attributeElm = XmlUtils.appendElement(attributesElm, "attribute");
            attributeElm.addAttribute("id", attribute.getId());
            attributeElm.addAttribute("name", attribute.getName());
            attributeElm.addAttribute("type", attribute.getType().getType());
            attributeElm.addAttribute("valueType", attribute.getValueType().getCode());
            this.appendRulesElement(attributeElm, attribute.getRules(), attribute.getId());
            this.appendOptionsElement(attributeElm, attribute.getOptions(), attribute.getId());
            this.appendAttributeValues(attribute, attributeElm);
        }
        this.appendRulesElement(attributeNode, this.getRules(), this.getId());
        return attributeNode;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }
}

