/*
 *  Copyright 2018 Alexey Andreev.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

var MyJava = MyJava || {};
MyJava.wasm = function() {
    class JavaError extends Error {
        constructor(message) {
            super(message)
        }
    }

    let lineBuffer = "";
    function putwchar(charCode) {
        if (charCode === 10) {
            console.log(lineBuffer);
            lineBuffer = "";
        } else {
            lineBuffer += String.fromCharCode(charCode);
        }
    }
    function towlower(code) {
        return String.fromCharCode(code).toLowerCase().charCodeAt(0);
    }
    function towupper(code) {
        return String.fromCharCode(code).toUpperCase().charCodeAt(0);
    }
    function GetBlockTimeStamp() {
        return parseInt(new Date().getTime() / 1000);
    }
    function getNativeOffset(instant) {
        return new Date(instant).getTimezoneOffset();
    }
    function println(data, len, controller) {
        try {
            let instance = controller.instance;
            let memory = instance.exports.memory.buffer;
            let arrayData = new DataView(memory, data, len);
            for (let i = 0; i < len; ++i) {
                putwchar(arrayData.getUint8(i, true));
            }
        }
        catch(err) {
            console.error(err);
        }
        
    }
    function MyAbort(data, len, controller) {
        try {
            console.log('MyAbort: ');
            let instance = controller.instance;
            let memory = instance.exports.memory.buffer;
            let arrayData = new DataView(memory, data, len);
            for (let i = 0; i < len; ++i) {
                putwchar(arrayData.getUint8(i, true));
            }
            putwchar('\n'.charCodeAt(0));
            return 0;
        }
        catch(err) {
            console.error(err);
        }
    }

    function abort(controller) {
        console.log('ABORT_CALLED');
        return 0;
    }

    function SetReturnValue(stringDataOffset, stringLength, controller) {
        try {
            let instance = controller.instance;
            let memory = instance.exports.memory.buffer;
            let arrayData = new DataView(memory, stringDataOffset, stringLength);
            for (let i = 0; i < stringLength; ++i) {
                putwchar(arrayData.getUint8(i, true));
            }
            putwchar(10);
       } catch(err) {
            console.error(err);
       }
    }

    let demoAbiName = () => (window.demoAbiName || "demoJavaSayHello");

    function ReadInterfaceNameSize(controller) {
        try {
            let instance = controller.instance;
            let memory = instance.exports.memory.buffer;
            return demoAbiName().length;
        } catch (err) {
            console.error(err);
        }
    }

    function ReadInterfaceName(dataOffset, lengthOffset, controller) {
        try {
            let instance = controller.instance;
            let memory = instance.exports.memory.buffer;
            let lengthData = new DataView(memory, lengthOffset, 4);
            let length = lengthData.getInt32(0, true);
            let arrayData = new DataView(memory, dataOffset, length);
            for (let i=0;i<length;i++) {
                arrayData.setInt8(i, demoAbiName()[i].charCodeAt(0));
            }
            return arrayData.length;
        } catch (err) {
            console.error(err);
        }
    }

    const demoAbiParams = () => (window.demoAbiParams || "exampleAbiParamsSerialized");

    function ReadInterfaceParamsSize(controller) {
        try {
            let instance = controller.instance;
            let memory = instance.exports.memory.buffer;
            return demoAbiParams().length;
        } catch (err) {
            console.error(err);
        }
    }

    function ReadInterfaceParams(dataOffset, lengthOffset, controller) {
        try {
            let instance = controller.instance;
            let memory = instance.exports.memory.buffer;
            let lengthData = new DataView(memory, lengthOffset, 4);
            let length = lengthData.getInt32(0, true);
            let arrayData = new DataView(memory, dataOffset, length);
            const params = demoAbiParams();
            for (let i=0;i<length;i++) {
                let paramByte;
                if (params instanceof String) {
                    paramByte = params[i].charCodeAt(0);
                } else {
                    paramByte = params[i];
                }
                arrayData.setInt8(i, paramByte);
            }
            return arrayData.length;
        } catch (err) {
            console.error(err);
        }
    }

    const demoTxHash = () => (window.demoTxHash || "aabbccddeeff");

    function GetTxHash(dataOffset, lengthOffset) {
        try {
            let instance = controller.instance;
            let memory = instance.exports.memory.buffer;
            let lengthData = new DataView(memory, lengthOffset, 4);
            let length = lengthData.getInt32(0, true);
            if (length > 255) {
                throw new Error(`too long txhash size ${length}`);
            }
            let arrayData = new DataView(memory, dataOffset, length);
            for (let i=0;i<length;i++) {
                arrayData.setInt8(i, demoTxHash()[i].charCodeAt(0));
            }
            return arrayData.length;
        } catch (err) {
            console.error(err);
        }
    }

    function Base64Encode(inputOffset, inputLength, outputOffset, outputLengthOffset, controller) {
        try {
            let instance = controller.instance;
            let memory = instance.exports.memory.buffer;
            let inputArrayData = new DataView(memory, inputOffset, inputLength);
            let binary = '';
            for (let i=0; i < inputLength; i++) {
                binary += String.fromCharCode(inputArrayData.getInt8(i));
            }
            const base64Str = btoa(binary);
            const outputLen = base64Str.length;
            let outputArrayData = new DataView(memory, outputOffset, outputLen);
            for (let i=0;i<outputLen;i++) {
                outputArrayData.setInt8(i, base64Str[i].charCodeAt(0));
            }
            // write length
            const outputLengthData = new DataView(memory, outputLengthOffset, 4);
            outputLengthData.setInt32(0, outputLen, true);
            return 1;
        } catch (err) {
            console.error(err);
        }
    }

    function GetRecoverKey (inputOffset, inputLength, outputOffset, outputLengthOffset, controller) {
          try {
              let instance = controller.instance;
              let memory = instance.exports.memory.buffer;
              let inputArrayData = new DataView(memory, inputOffset, inputLength);
              // 目前测试返回固定值
              const resultHexStr = '6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b6b';
              const outputLen = resultHexStr.length / 2;
              let outputArrayData = new DataView(memory, outputOffset, outputLen);
              for (let i=0;i<outputLen;i++) {
                  const charCode = parseInt(resultHexStr.substr(i*2, 2), 16);
                  outputArrayData.setInt8(i, charCode);
              }
              // write length
              const outputLengthData = new DataView(memory, outputLengthOffset, 4);
              outputLengthData.setInt32(0, outputLen, true);
              return 0;
          } catch (err) {
              console.error(err);
          }
    }

    function GetCallResultSize(controller) {
        try {
            console.log('exec hostapi GetCallResultSize');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function GetSelf(controller) {
        try {
            console.log('exec hostapi GetSelf');
            return 0; // TODO: return self contract address
        } catch (err) {
            console.error(err);
        }
    }

    function GetBlockNumber(controller) {
        return 1234;
    }

    function GetBlockHash(blockNum, blockHashDataOffset, blockHashLenOffset) {
        try {
            console.log('exec hostapi GetBlockHash');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function CheckAccount(data, length, controller) {
        try {
            console.log('exec hostapi CheckAccount');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function GetOrigin(data, lenOffset, controller) {
        try {
            console.log('exec hostapi GetOrigin');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function GetAuthMap(a, b, c, d, controller) {
        try {
            console.log('exec hostapi GetAuthMap');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function GetAuthMapInCache(a, b, c, d, controller) {
        try {
            console.log('exec hostapi GetAuthMapInCache');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function GetCode(a, b, c, d, controller) {
        try {
            console.log('exec hostapi GetCode');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function GetCodeHash(a, b, c, d, controller) {
        try {
            console.log('exec hostapi GetCodeHash');
            return GetCodeHash;
        } catch (err) {
            console.error(err);
        }
    }

    function GetBalance(a, b, c, controller) {
        try {
            console.log('exec hostapi GetBalance');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function GetValue(controller) {
        try {
            console.log('exec hostapi GetValue');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function IsLocalTx(controller) {
        try {
            console.log('exec hostapi IsLocalTx');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function GetTransaction(a, b, c, controller) {
        try {
            console.log('exec hostapi GetTransaction');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function CreateContract(a, b, c, d, controller) {
        try {
            console.log('exec hostapi CreateContract');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function Base64Decode(a, b, c, d, controller) {
        try {
            return 0; // TODO
        } catch (err) {
            console.error(err);
        }
    }

    function GetAccountStatus(a, b, c, controller) {
        try {
            console.log('exec hostapi GetAccountStatus');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function TransferBalance(a, b, c, controller) {
        try {
            console.log('exec hostapi TransferBalance');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function ReadBuffer(a, b, controller) {
        try {
            console.log('exec hostapi ReadBuffer');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function GetCallResult(controller) {
        try {
            console.log('exec hostapi GetCallResult');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }

    function CallContract(a, b, c, d, e, f, g, h, controller) {
        try {
            console.log('exec hostapi CallContract');
            return 0;
        } catch (err) {
            console.error(err);
        }
    }



    function logInt(i) {
        lineBuffer += i.toString();
    }
//    function interrupt(controller) {
//        if (controller.timer !== null) {
//            clearTimeout(controller.timer);
//            controller.timer = null;
//        }
//        controller.timer = setTimeout(() => process(controller), 0);
//    }
//    function process(controller) {
//        let result = controller.instance.exports.myjava_processQueue();
//        if (!controller.complete) {
//            if (controller.instance.exports.myjava_stopped()) {
//                controller.complete = true;
//                controller.resolve();
//            }
//        }
//        if (result >= 0) {
//            controller.timer = setTimeout(() => process(controller), result)
//        }
//    }

    const memoryTraceEnabled = false; // 通过这个开关可以开启关闭是否trace memory

    function defaults(obj) {
        let controller = {};
        controller.instance = null;
        controller.timer = null;
        controller.resolve = null;
        controller.reject = null;
        controller.complete = false;
        obj.env = {
            GetBlockTimeStamp: (a, b) => GetBlockTimeStamp(a, b, controller),
            println: (a, b) => println(a, b, controller),
//            logInt: logInt,
            // MyAbort: (a, b) => console.log("Out of memory ant"),
            MyAbort: (a, b) => MyAbort(a, b, controller),
            abort: () => abort(controller),
            SetReturnValue: (a, b) => SetReturnValue(a, b, controller),
            ReadInterfaceNameSize: () => ReadInterfaceNameSize(controller),
            ReadInterfaceName: (dataOffset, lengthOffset) => ReadInterfaceName(dataOffset, lengthOffset, controller),
            ReadInterfaceParamsSize: () => ReadInterfaceParamsSize(controller),
            ReadInterfaceParams: (dataOffset, lengthOffset) => ReadInterfaceParams(dataOffset, lengthOffset, controller),
            GetTxHash: (a, b, c) => GetTxHash(controller),
            Base64Encode: (a, b, c, d) => Base64Encode(a, b, c, d, controller),
            Base64Decode: (a, b, c, d) => Base64Decode(a, b, c, d, controller),
            GetRecoverKey: (a, b, c, d) => GetRecoverKey(a, b, c, d, controller),
            GetCallResultSize: () => GetCallResultSize(controller),
            GetSelf: () => GetSelf(controller),
            GetCallResult: () => GetCallResult(controller),
            CallContract: (a, b, c, d, e, f, g, h) => CallContract(a, b, c, d, e, f, g, h, controller),
            GetBlockNumber: () => GetBlockNumber(controller),
            GetBlockHash: (a, b, c) => GetBlockHash(a, b, c, controller),
            CheckAccount: (a, b) => CheckAccount(a, b, controller),
            GetOrigin: (a, b) => GetOrigin(a, b, controller),
            GetAuthMap: (a, b, c, d) => GetAuthMap(a, b, c, d, controller),
            GetAuthMapInCache: (a, b, c, d) => GetAuthMapInCache(a, b, c, d, controller),
            GetBalance: (a, b, c) => GetBalance(a, b, c, controller),
            GetValue: () => GetValue(controller),
            IsLocalTx: () => IsLocalTx(controller),
            GetTransaction: (a, b, c, d) => GetTransaction(a, b, c, d, controller),
            GetCode: (a, b, c, d) => GetCode(a, b, c, d, controller),
            GetCodeHash: (a, b, c, d) => GetCodeHash(a, b, c, d, controller),
            GetAccountStatus: (a, b, c) => GetAccountStatus(a, b, c, controller),
            TransferBalance: (a, b, c) => TransferBalance(a, b, c, controller),
            ReadBuffer: (a, b) => ReadBuffer(a, b, controller),
            CreateContract: (a, b, c, d) => CreateContract(a, b, c, d, controller),
            AddPedersenCommit: (a1,a2,a3,a4,a5,a6,a7) => 0,
            SubPedersenCommit: (a1,a2,a3,a4,a5,a6,a7) => 0,
            CalculatePedersenCommit: (a1,a2,a3,a4,a5,a6,a7,a8,a9) => 0,
            GetStorageSize: (a, b, c) => 0,
            GetStorage: (a, b, c) => 1011,
            SetStorage: (a,b,c,d) => 0,
            DeleteStorage: (a, b) => 0,
            Log: (a, b, c, d) => 0,
            GetDataSize: () => 0,
            GetData: (a, b) => 0,
            GetSender: (a, b) => 0,
            GetRelatedTransactionListSize: (a, b, c, d) => 0,
            GetRelatedTransactionList: (a, b, c, d, e, f) => 0,
            GetConfidentialDeposit: (a, b, c, d) => 0,
            Digest: (a, b, c, d, e) => 0,
            VerifyRsa2: (a, b, c, d, e, f, g) => 0,
            Ecrecovery: (a, b, c, d, e, f) => 0,
            VerifyMessageSM2: (a, b, c, d, e, f, g) => 0,
            VerifyMessageECCK1: (a, b, c, d, e, f, g) => 0,
            VerifyMessageECCR1: (a, b, c, d, e, f, g) => 0,
            BellmanSnarkVerify: (a, b, c, d, e, f) => 0,
            RangeProofVerify: (a, b, c, d, e) => 0,
            PedersenCommitEqualityVerify: (a, b, c, d, e) => 0,
            Result: (a, b) => 0,
            ReadBufferRef: (a, b) => 0,
            VerifyCommitment: (a, b) => 0,
            VerifyRange: (a, b) => 0,
            VerifyBalance: (a, b) => 0,
            FTraceBegin: (a, b) => 0,
            DeployContract: (a, b, c, d, e, f) => 0,
            UpdateContract: (a, b, c) => 0,
            UpdateContractStatus: (a, b) => 0,
            DCGetStorageSize: (a, b, c, d, e) => 0,
            DCSetStorage: (a, b, c, d, e, f) => 0,
            DCDeleteStorage: (a, b, c, d) => 0,
            DCSetAcl: (a, b, c, d) => 0,
            GrayscaleDeployContract: (a, b, c) => 0,
            GrayscaleVerification: (a) => 0,
            GrayscaleVersionSwitchBack: (a) => 0,
            GrayscaleUpdateContract: (a) => 0,
            LiftedElgamalContractHomomorphicAdd: () => 0,
            LiftedElgamalContractHomomorphicSub: () => 0,
            LiftedElgamalScalarMutiply: () => 0,
            LiftedElgamalContractZeroCheckVerify: () => 0,
            LiftedElgamalContractRangeVerify: () => 0,
        };
        obj.myjava = {
            nanoTime: function() { return performance.now(); },
            isnan: isNaN,
            myjava_getNaN: function() { return NaN; },
            isinf: function(n) { return !isFinite(n) },
            isfinite: isFinite,
            putwchar: putwchar,
            towlower: towlower,
            towupper: towupper,
            getNativeOffset: getNativeOffset,
//            myjava_interrupt: () => interrupt(controller)
        };

        obj.myjavaMath = Math;

        obj.myjavaHeapTrace = {
            memory_trace_allocate: function(address, size) {
                if (memoryTraceEnabled) {
                    console.log(`memory allocate address ${address} size ${size}`);
                }
            },
            memory_trace_free: function(address, size) {
                if (memoryTraceEnabled) {
                    console.log(`memory free address ${address} size ${size}`);
                }
            },
            memory_trace_assertFree: function(address, size) {
                if (memoryTraceEnabled) {
                    console.log(`memory assertFree address ${address} size ${size}`);
                }
            },
            memory_trace_markStarted: function() {
                if (memoryTraceEnabled) {
                    console.log(`memory markStarted`);
                }
            },
            memory_trace_mark: function(address) {
                if (memoryTraceEnabled) {
                    console.log(`memory mark address ${address}`);
                }
            },
            memory_trace_markCompleted: function() {
                if (memoryTraceEnabled) {
                    console.log(`memory markCompleted`);
                }
            },
            memory_trace_move: function(from, to, size) {
                if (memoryTraceEnabled) {
                    console.log(`memory move from ${from} to ${to} size ${size}`);
                }
            },
            memory_trace_gcStarted: function(full) {
                if (memoryTraceEnabled) {
                    console.log(`memory gcStarted ${full?'full':'not-full'}`);
                }
            },
            memory_trace_sweepStarted: function() {
                if (memoryTraceEnabled) {
                    console.log(`memory sweepStarted`);
                }
            },
            memory_trace_sweepCompleted: function() {
                if (memoryTraceEnabled) {
                    console.log(`memory sweepCompleted`);
                }
            },
            memory_trace_gcCompleted: function() {
                if (memoryTraceEnabled) {
                    console.log(`memory gcCompleted`);
                }
            },
            memory_trace_resizeHeap: function(oldHeapSize, newHeapSize, newMemoryLimit) {
                if (memoryTraceEnabled) {
                    console.log(`memory resizeHeap from heap size from ${oldHeapSize} to ${newHeapSize}, new memory limit: ${newMemoryLimit}`);
                }
            },
            memory_trace_init: function(maxHeap) {
                if (memoryTraceEnabled) {
                    console.log(`memory init heap`);
                }
            }
        };

        return controller;
    }

    function createMyJava(instance) {
        let vm = {
            memory: instance.exports.memory,
            instance,
            catchException: instance.exports.myjava_catchException
        }

        for (const name of ["allocateString", "stringData", "allocateObjectArray", "allocateStringArray",
            "allocateByteArray", "allocateShortArray", "allocateCharArray", "allocateIntArray",
            "allocateLongArray", "allocateFloatArray", "allocateDoubleArray",
            "objectArrayData", "byteArrayData", "shortArrayData", "charArrayData", "intArrayData",
            "longArrayData", "floatArrayData", "doubleArrayData", "arrayLength"]) {
            vm[name] = wrapExport(instance.exports["myjava_" + name], instance);
        }

        vm.main = createMain(vm, instance.exports.main);
        return vm;
    }

    function wrapExport(fn, instance) {
        return function() {
            let result = fn.apply(this, arguments);
            let ex = catchException(instance);
            if (ex !== null) {
                throw ex;
            }
            return result;
        }
    }

    function catchException(instance) {
        let ex = instance.exports.myjava_catchException();
        if (ex !== 0) {
            return new JavaError("Uncaught exception occurred in Java");
        }
        return null;
    }

    function load(path, options) {
        let xhr = new XMLHttpRequest();
        xhr.responseType = "arraybuffer";
        xhr.open("GET", path);

        return new Promise((resolve, reject) => {
            xhr.onload = () => {
                let response = xhr.response;
                if (!response) {
                    reject("Error loading Wasm data")
                    return;
                }

                resolve(response);
            };
            xhr.send();
        }).then(data => create(data, options));
    }

    function create(data, options) {
        if (!options) {
            options = {};
        }

        const importObj = {};
        const controller = defaults(importObj);
        if (typeof options.installImports !== "undefined") {
            options.installImports(importObj);
        }

        return WebAssembly.instantiate(data, importObj).then(resultObject => {
            controller.instance = resultObject.instance;
            let vm = createMyJava(resultObject.instance);
            vm.main = createMain(vm, controller);
            return vm;
        });
    }

    function createMain(vm, controller) {
        return function(args) {
            if (typeof args === "undefined") {
                args = [];
            }
            return new Promise((resolve, reject) => {
                let javaArgs = vm.allocateStringArray(args.length);
                let javaArgsData = new DataView(vm.memory.buffer, vm.objectArrayData(javaArgs), args.length * 4);
                for (let i = 0; i < args.length; ++i) {
                    let arg = args[i];
                    let javaArg = vm.allocateString(arg.length);
                    let javaArgAddress = vm.objectArrayData(vm.stringData(javaArg));
                    let javaArgData = new DataView(vm.memory.buffer, javaArgAddress, arg.length * 2);
                    for (let j = 0; j < arg.length; ++j) {
                        javaArgData.setUint16(j * 2, arg.charCodeAt(j), true);
                    }
                    javaArgsData.setInt32(i * 4, javaArg, true);
                }

                controller.resolve = resolve;
                controller.reject = reject;
                wrapExport(vm.instance.exports.apply, vm.instance)(javaArgs);
//                process(controller);
            });
        }
    }

    return { JavaError, load, create };
}();
