/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.tooling.daemon;

import com.antgroup.antchain.myjava.tooling.MyJavaToolException;
import com.antgroup.antchain.myjava.tooling.MyJavaVMTool;
import com.antgroup.antchain.myjava.tooling.daemon.DaemonInfo;
import com.antgroup.antchain.myjava.tooling.daemon.DaemonLog;
import com.antgroup.antchain.myjava.tooling.daemon.RemoteBuildCallback;
import com.antgroup.antchain.myjava.tooling.daemon.RemoteBuildLog;
import com.antgroup.antchain.myjava.tooling.daemon.RemoteBuildRequest;
import com.antgroup.antchain.myjava.tooling.daemon.RemoteBuildResponse;
import com.antgroup.antchain.myjava.tooling.daemon.RemoteBuildService;
import com.antgroup.antchain.myjava.tooling.sources.DirectorySourceFileProvider;
import com.antgroup.antchain.myjava.tooling.sources.JarSourceFileProvider;
import com.antgroup.antchain.myjava.vm.MyJavaPhase;
import com.antgroup.antchain.myjava.vm.MyJavaProgressFeedback;
import com.antgroup.antchain.myjava.vm.MyJavaProgressListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.rmi.AlreadyBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teavm.apachecommons.io.FileUtils;
import org.teavm.apachecommons.io.IOUtils;

public class BuildDaemon
extends UnicastRemoteObject
implements RemoteBuildService {
    private static final Logger log = LoggerFactory.getLogger(BuildDaemon.class);
    private static final int MIN_PORT = 10000;
    private static final int MAX_PORT = 65536;
    private static final String DAEMON_MESSAGE_PREFIX = "MyJavaVM daemon port: ";
    private static final String INCREMENTAL_PROPERTY = "teavm.daemon.incremental";
    private static final String DEBUG_PORT_PROPERTY = "teavm.daemon.debug.port";
    private boolean incremental;
    private int port;
    private Registry registry;
    private File incrementalCache;
    private ClassLoader lastJarClassLoader;
    private List<String> lastJarClassPath;

    BuildDaemon(boolean incremental) throws RemoteException {
        this.incremental = incremental;
        Random random = new Random();
        for (int i = 0; i < 20; ++i) {
            this.port = random.nextInt(55536) + 10000;
            try {
                this.registry = LocateRegistry.createRegistry(this.port);
            }
            catch (RemoteException e) {
                continue;
            }
            try {
                this.registry.bind("MyJavaVM-Daemon", this);
            }
            catch (AlreadyBoundException | RemoteException e) {
                throw new IllegalStateException("Could not bind remote build assistant service", e);
            }
            this.setupIncrementalCache();
            return;
        }
        throw new IllegalStateException("Could not create RMI registry");
    }

    private void setupIncrementalCache() {
        if (!this.incremental) {
            return;
        }
        Thread mainThread = Thread.currentThread();
        try {
            this.incrementalCache = Files.createTempDirectory("myjava-cache", new FileAttribute[0]).toFile();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    if (this.incrementalCache != null) {
                        FileUtils.deleteDirectory(this.incrementalCache);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    mainThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }));
        }
        catch (IOException e) {
            System.err.println("Could not setup incremental cache");
            e.printStackTrace(System.err);
            this.incremental = false;
        }
    }

    public static void main(String[] args) throws RemoteException {
        boolean incremental = Boolean.parseBoolean(System.getProperty(INCREMENTAL_PROPERTY, "false"));
        BuildDaemon daemon = new BuildDaemon(incremental);
        log.info(DAEMON_MESSAGE_PREFIX + daemon.port);
        if (daemon.incrementalCache != null) {
            log.info("Incremental cache set up in " + daemon.incrementalCache);
        }
    }

    @Override
    public RemoteBuildResponse build(RemoteBuildRequest request, RemoteBuildCallback callback) {
        log.info("Build started");
        MyJavaVMTool tool = new MyJavaVMTool();
        tool.setIncremental(this.incremental || request.incremental);
        if (tool.isIncremental()) {
            tool.setCacheDirectory(request.cacheDirectory != null ? new File(request.cacheDirectory) : this.incrementalCache);
        }
        tool.setProgressListener(this.createProgressListener(callback));
        tool.setLog(new RemoteBuildLog(callback));
        if (request.transformers != null) {
            tool.getTransformers().addAll(Arrays.asList(request.transformers));
        }
        if (request.classesToPreserve != null) {
            tool.getClassesToPreserve().addAll(Arrays.asList(request.classesToPreserve));
        }
        tool.setTargetType(request.targetType);
        tool.setMainClass(request.mainClass);
        tool.setEntryPointName(request.entryPointName);
        tool.setTargetDirectory(new File(request.targetDirectory));
        tool.setTargetFileName(request.tagetFileName);
        tool.setClassLoader(this.buildClassLoader(request.classPath, this.incremental && request.incremental));
        tool.setSourceMapsFileGenerated(request.sourceMapsFileGenerated);
        tool.setDebugInformationGenerated(request.debugInformationGenerated);
        tool.setSourceFilesCopied(request.sourceFilesCopied);
        if (request.properties != null) {
            tool.getProperties().putAll((Map<?, ?>)request.properties);
        }
        tool.setOptimizationLevel(request.optimizationLevel);
        tool.setFastDependencyAnalysis(request.fastDependencyAnalysis);
        tool.setObfuscated(request.obfuscated);
        tool.setEnableMemoryTraceHooks(request.enableMemoryTraceHooks);
        tool.setStrict(request.strict);
        tool.setMaxTopLevelNames(request.maxTopLevelNames);
        tool.setWasmVersion(request.wasmVersion);
        tool.setWasmSectionCode(request.wasmSectionCode);
        tool.setOptimizeWasmStart(request.optimizeWasmStart);
        tool.setCompressWasm(request.compressWasm);
        tool.setDumpNames(request.dumpNames);
        tool.setMinHeapSize(request.minHeapSize);
        tool.setMaxHeapSize(request.maxHeapSize);
        tool.setMaxMemorySize(request.maxMemorySize);
        tool.setLongjmpSupported(request.longjmpSupported);
        tool.setHeapDump(request.heapDump);
        for (String sourceDirectory : request.sourceDirectories) {
            tool.addSourceFileProvider(new DirectorySourceFileProvider(new File(sourceDirectory)));
        }
        for (String sourceJar : request.sourceJarFiles) {
            tool.addSourceFileProvider(new JarSourceFileProvider(new File(sourceJar)));
        }
        RemoteBuildResponse response = new RemoteBuildResponse();
        try {
            tool.generate();
            log.info("Build complete");
        }
        catch (MyJavaToolException | Error | RuntimeException e) {
            response.exception = e;
        }
        if (response.exception == null) {
            response.callGraph = tool.getDependencyInfo().getCallGraph();
            response.problems.addAll(tool.getProblemProvider().getProblems());
            response.severeProblems.addAll(tool.getProblemProvider().getSevereProblems());
            response.classes.addAll(tool.getClasses());
            response.usedResources.addAll(tool.getUsedResources());
            response.generatedFiles.addAll(tool.getGeneratedFiles().stream().map(File::getAbsolutePath).collect(Collectors.toSet()));
        }
        return response;
    }

    private ClassLoader buildClassLoader(List<String> classPathEntries, boolean incremental) {
        log.info("Classpath: " + classPathEntries);
        Function<String, URL> mapper = entry -> {
            try {
                return new File((String)entry).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException((String)entry);
            }
        };
        List jarEntries = classPathEntries.stream().filter(entry -> entry.endsWith(".jar")).collect(Collectors.toList());
        ClassLoader jarClassLoader = null;
        if (incremental) {
            if (jarEntries.equals(this.lastJarClassPath) && this.lastJarClassLoader != null) {
                jarClassLoader = this.lastJarClassLoader;
                log.info("Reusing previous class path");
            }
        } else {
            this.lastJarClassLoader = null;
            this.lastJarClassPath = null;
        }
        if (jarClassLoader == null) {
            URL[] jarUrls = (URL[])jarEntries.stream().map(mapper).toArray(URL[]::new);
            jarClassLoader = new URLClassLoader(jarUrls);
        }
        if (incremental) {
            this.lastJarClassPath = jarEntries;
            this.lastJarClassLoader = jarClassLoader;
        }
        URL[] urls = (URL[])classPathEntries.stream().filter(entry -> !entry.endsWith(".jar")).map(mapper).toArray(URL[]::new);
        return new URLClassLoader(urls, jarClassLoader);
    }

    private MyJavaProgressListener createProgressListener(final RemoteBuildCallback callback) {
        return new MyJavaProgressListener(){
            private long lastReportedTime;

            @Override
            public MyJavaProgressFeedback phaseStarted(MyJavaPhase phase, int count) {
                try {
                    return callback.phaseStarted(phase, count);
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public MyJavaProgressFeedback progressReached(int progress) {
                if (System.currentTimeMillis() - this.lastReportedTime > 100L) {
                    this.lastReportedTime = System.currentTimeMillis();
                    try {
                        return callback.progressReached(progress);
                    }
                    catch (RemoteException e) {
                        throw new RuntimeException(e);
                    }
                }
                return MyJavaProgressFeedback.CONTINUE;
            }
        };
    }

    public static DaemonInfo start(boolean incremental, int daemonMemory, DaemonLog log, String ... classPathEntries) throws IOException {
        String javaHome = System.getProperty("java.home");
        String javaCommand = javaHome + "/bin/java";
        String classPath = String.join((CharSequence)File.pathSeparator, classPathEntries);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(Arrays.asList(javaCommand, "-cp", classPath, "-Dteavm.daemon.incremental=" + incremental, "-Xmx" + daemonMemory + "m"));
        String debugPort = System.getProperty(DEBUG_PORT_PROPERTY);
        if (debugPort != null) {
            arguments.add("-agentlib:jdwp=transport=dt_socket,quiet=y,server=y,address=" + debugPort + ",suspend=y");
        }
        arguments.add(BuildDaemon.class.getName());
        ProcessBuilder builder = new ProcessBuilder(arguments.toArray(new String[0]));
        Process process = builder.start();
        BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        BufferedReader stderrReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
        String line = stdoutReader.readLine();
        if (line == null || !line.startsWith(DAEMON_MESSAGE_PREFIX)) {
            StringBuilder sb = new StringBuilder();
            while ((line = stderrReader.readLine()) != null) {
                sb.append(line).append('\n');
            }
            IOUtils.closeQuietly(stderrReader);
            IOUtils.closeQuietly(stdoutReader);
            process.destroy();
            throw new IllegalStateException("Could not start daemon. Stderr: " + sb);
        }
        int port = Integer.parseInt(line.substring(DAEMON_MESSAGE_PREFIX.length()));
        BuildDaemon.daemonThread(new DaemonProcessOutputWatcher(log, stdoutReader, "stdout", false)).start();
        BuildDaemon.daemonThread(new DaemonProcessOutputWatcher(log, stderrReader, "stderr", true)).start();
        return new DaemonInfo(port, process);
    }

    private static Thread daemonThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        return thread;
    }

    static class DaemonProcessOutputWatcher
    implements Runnable {
        private DaemonLog log;
        private BufferedReader reader;
        private String name;
        private boolean isError;

        DaemonProcessOutputWatcher(DaemonLog log, BufferedReader reader, String name, boolean isError) {
            this.log = log;
            this.reader = reader;
            this.name = name;
            this.isError = isError;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    if (this.isError) {
                        this.log.error("Build daemon [" + this.name + "]: " + line);
                        continue;
                    }
                    this.log.info("Build daemon [" + this.name + "]: " + line);
                }
            }
            catch (IOException e) {
                this.log.error("Error reading build daemon output", e);
            }
        }
    }
}

