/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.runtime;

import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.runtime.HexException;
import com.antgroup.antchain.myjava.runtime.Identity;
import com.antgroup.antchain.myjava.runtime.MychainLib;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;

@NoMetadata
public class ParamsStream {
    private int offset;
    private int length;
    private byte[] source;

    public ParamsStream(byte[] abiParamsBytes) {
        if (abiParamsBytes == null) {
            throw new NullPointerException();
        }
        this.offset = 0;
        this.length = abiParamsBytes.length;
        this.source = abiParamsBytes;
    }

    public void requireEnd() {
        if (this.offset < this.length) {
            MychainLib.revertString("PARAMS_NOT_MATCH: there should be no more params.");
        }
    }

    private void requireEnoughStream(int len) {
        if (len > this.length - this.offset) {
            MychainLib.revertString("PARAMS_NOT_MATCH: the input len is bigger than available bytes length.");
        }
    }

    public byte[] availableBytes() {
        int availableLen = this.length - this.offset;
        if (availableLen > 0) {
            byte[] currentParam = new byte[availableLen];
            this.read(currentParam, 0, availableLen);
            return currentParam;
        }
        return null;
    }

    private int byteArrayToInt32(byte[] byteArray) {
        int value = byteArray[0] & 0xFF | (byteArray[1] & 0xFF) << 8 | (byteArray[2] & 0xFF) << 16 | (byteArray[3] & 0xFF) << 24;
        return value;
    }

    public static byte[] encodeULeb128(int value) {
        if (value == 0) {
            return new byte[]{0};
        }
        ArrayList<Byte> targetList = new ArrayList<Byte>();
        while (value != 0) {
            int tmpValue = value & 0x7F;
            if ((value >>= 7) != 0) {
                tmpValue |= 0x80;
            }
            targetList.add((byte)tmpValue);
        }
        byte[] targetByte = new byte[targetList.size()];
        int pos = 0;
        Iterator iterator = targetList.iterator();
        while (iterator.hasNext()) {
            byte tmp = (Byte)iterator.next();
            targetByte[pos++] = tmp;
        }
        return targetByte;
    }

    private int read() {
        if (this.offset >= this.length) {
            return -1;
        }
        byte b = this.source[this.offset];
        ++this.offset;
        return b & 0xFF;
    }

    private int read(byte[] buf, int bufOffset, int readLen) {
        if (this.offset >= this.length) {
            return -1;
        }
        int toReadCount = readLen;
        if (toReadCount > this.length - this.offset) {
            toReadCount = this.length - this.offset;
        }
        for (int i = 0; i < toReadCount; ++i) {
            buf[bufOffset + i] = this.source[this.offset + i];
        }
        this.offset += toReadCount;
        return toReadCount;
    }

    public int decodeULeb128() {
        int value;
        int pos = 0;
        int ret = 0;
        do {
            if ((value = this.read()) == -1) {
                return -1;
            }
            int tmpValue = value & 0x7F;
            ret |= tmpValue << 7 * pos;
            ++pos;
        } while ((value & 0x80) == 128);
        return ret;
    }

    public int readInt() {
        this.requireEnoughStream(4);
        byte[] currentParam = new byte[4];
        if (this.read(currentParam, 0, 4) == -1) {
            MychainLib.revertString("readInt32 deserialize failed");
        }
        return this.byteArrayToInt32(currentParam);
    }

    public String readString() {
        int len = this.decodeULeb128();
        if (len == -1 || len == 0) {
            return "";
        }
        this.requireEnoughStream(len);
        byte[] currentParam = new byte[len];
        if (this.read(currentParam, 0, len) == -1) {
            MychainLib.revertString("readString deserialize failed");
        }
        return new String(currentParam, StandardCharsets.UTF_8);
    }

    public String readHexString() {
        int len = this.decodeULeb128();
        if (len == -1 || len == 0) {
            return "";
        }
        this.requireEnoughStream(len);
        byte[] currentParam = new byte[len];
        if (this.read(currentParam, 0, len) == -1) {
            MychainLib.revertString("readHexString deserialize failed");
        }
        return MychainLib.bytesToHex(currentParam);
    }

    public boolean readBoolean() {
        int value = this.read();
        if (value == -1) {
            MychainLib.revertString("readBoolean deserialize failed");
        }
        if (value == 1) {
            return true;
        }
        if (value == 0) {
            return false;
        }
        MychainLib.revertString("readBoolean deserialize value failed, wrong type");
        return false;
    }

    public byte readByte() {
        int value = this.read();
        if (value == -1) {
            MychainLib.revertString("readByte deserialize failed");
        }
        return (byte)value;
    }

    public char readChar() {
        int value = this.read();
        if (value == -1) {
            MychainLib.revertString("readChar deserialize failed");
        }
        return (char)value;
    }

    public long readLong() {
        this.requireEnoughStream(8);
        byte[] currentParam = new byte[8];
        if (this.read(currentParam, 0, 8) == -1) {
            MychainLib.revertString("readInt64 deserialize failed");
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(currentParam, 0, 8);
        buffer.flip();
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer.getLong();
    }

    public int[] readIntArray() {
        int len = this.decodeULeb128();
        if (len == -1 || len == 0) {
            return new int[0];
        }
        int[] retList = new int[len];
        for (int i = 0; i < len; ++i) {
            retList[i] = this.readInt();
        }
        return retList;
    }

    public long[] readLongArray() {
        int len = this.decodeULeb128();
        if (len == -1 || len == 0) {
            return new long[0];
        }
        long[] retList = new long[len];
        for (int i = 0; i < len; ++i) {
            retList[i] = this.readLong();
        }
        return retList;
    }

    public String[] readStringArray() {
        int len = this.decodeULeb128();
        if (len == -1 || len == 0) {
            return new String[0];
        }
        String[] retList = new String[len];
        for (int i = 0; i < len; ++i) {
            retList[i] = this.readString();
        }
        return retList;
    }

    public String[] readHexStringArray() {
        int len = this.decodeULeb128();
        if (len == -1 || len == 0) {
            return new String[0];
        }
        String[] retList = new String[len];
        for (int i = 0; i < len; ++i) {
            retList[i] = this.readHexString();
        }
        return retList;
    }

    public byte[] readByteArray() {
        int len = this.decodeULeb128();
        if (len == -1 || len == 0) {
            return new byte[0];
        }
        byte[] retList = new byte[len];
        for (int i = 0; i < len; ++i) {
            retList[i] = this.readByte();
        }
        return retList;
    }

    public char[] readCharArray() {
        int len = this.decodeULeb128();
        if (len == -1 || len == 0) {
            return new char[0];
        }
        char[] retList = new char[len];
        for (int i = 0; i < len; ++i) {
            retList[i] = this.readChar();
        }
        return retList;
    }

    public boolean[] readBooleanArray() {
        int len = this.decodeULeb128();
        if (len == -1 || len == 0) {
            return new boolean[0];
        }
        boolean[] retList = new boolean[len];
        for (int i = 0; i < len; ++i) {
            retList[i] = this.readBoolean();
        }
        return retList;
    }

    public Identity readIdentity() {
        int len = this.decodeULeb128();
        if (len == -1 || len == 0) {
            MychainLib.revertString("Identity type input should not be empty.");
        }
        this.requireEnoughStream(len);
        MychainLib.require(len == 32, "unpacked Identity size don't match 32");
        byte[] currentParam = new byte[len];
        if (this.read(currentParam, 0, len) == -1) {
            MychainLib.revertString("readIdentity deserialize failed");
        }
        return new Identity(currentParam);
    }

    public Identity[] readIdentityArray() {
        int len = this.decodeULeb128();
        if (len == -1 || len == 0) {
            return new Identity[0];
        }
        Identity[] retList = new Identity[len];
        for (int i = 0; i < len; ++i) {
            retList[i] = this.readIdentity();
        }
        return retList;
    }

    public static byte[] packInt(int target) {
        byte[] result = new byte[4];
        result[3] = (byte)(target >> 24 & 0xFF);
        result[2] = (byte)(target >> 16 & 0xFF);
        result[1] = (byte)(target >> 8 & 0xFF);
        result[0] = (byte)(target & 0xFF);
        return result;
    }

    public static byte[] packLong(long value) {
        byte[] result = new byte[8];
        result[7] = (byte)(value >> 56 & 0xFFL);
        result[6] = (byte)(value >> 48 & 0xFFL);
        result[5] = (byte)(value >> 40 & 0xFFL);
        result[4] = (byte)(value >> 32 & 0xFFL);
        result[3] = (byte)(value >> 24 & 0xFFL);
        result[2] = (byte)(value >> 16 & 0xFFL);
        result[1] = (byte)(value >> 8 & 0xFFL);
        result[0] = (byte)(value & 0xFFL);
        return result;
    }

    public static byte[] packString(String target) {
        if (target == null) {
            throw new NullPointerException();
        }
        byte[] valueByte = target.getBytes(StandardCharsets.UTF_8);
        int valueLen = valueByte.length;
        byte[] lenByte = ParamsStream.encodeULeb128(valueLen);
        int lenLen = lenByte.length;
        byte[] targetByte = new byte[lenLen + valueLen];
        System.arraycopy(lenByte, 0, targetByte, 0, lenLen);
        System.arraycopy(valueByte, 0, targetByte, lenLen, valueLen);
        return targetByte;
    }

    public static byte[] packHexString(String target) throws HexException {
        if (target == null) {
            throw new NullPointerException();
        }
        byte[] valueByte = MychainLib.hexToBytes(target);
        int valueLen = valueByte.length;
        byte[] lenByte = ParamsStream.encodeULeb128(valueLen);
        int lenLen = lenByte.length;
        byte[] targetByte = new byte[lenLen + valueLen];
        System.arraycopy(lenByte, 0, targetByte, 0, lenLen);
        System.arraycopy(valueByte, 0, targetByte, lenLen, valueLen);
        return targetByte;
    }

    public static byte[] packBoolean(boolean target) {
        byte[] targetByte = new byte[]{target ? (byte)1 : 0};
        return targetByte;
    }

    public static byte[] packByte(byte target) {
        byte[] targetByte = new byte[]{target};
        return targetByte;
    }

    public static byte[] packChar(char target) {
        byte[] targetByte = new byte[]{(byte)target};
        return targetByte;
    }

    public static byte[] packIntArray(int[] target) {
        if (target == null) {
            throw new NullPointerException();
        }
        int arrLen = target.length;
        byte[] arrLenByte = ParamsStream.encodeULeb128(arrLen);
        int lenLen = arrLenByte.length;
        byte[] targetByte = new byte[lenLen + arrLen * 4];
        System.arraycopy(arrLenByte, 0, targetByte, 0, lenLen);
        for (int i = 0; i < arrLen; ++i) {
            byte[] tmpByte = ParamsStream.packInt(target[i]);
            System.arraycopy(tmpByte, 0, targetByte, lenLen + i * 4, 4);
        }
        return targetByte;
    }

    public static byte[] packLongArray(long[] target) {
        if (target == null) {
            throw new NullPointerException();
        }
        int arrLen = target.length;
        byte[] arrLenByte = ParamsStream.encodeULeb128(arrLen);
        int lenLen = arrLenByte.length;
        byte[] targetByte = new byte[lenLen + arrLen * 8];
        System.arraycopy(arrLenByte, 0, targetByte, 0, lenLen);
        for (int i = 0; i < arrLen; ++i) {
            byte[] tmpByte = ParamsStream.packLong(target[i]);
            System.arraycopy(tmpByte, 0, targetByte, lenLen + i * 8, 8);
        }
        return targetByte;
    }

    public static byte[] packStringArray(String[] target) {
        if (target == null) {
            throw new NullPointerException();
        }
        int arrLen = target.length;
        byte[] arrLenByte = ParamsStream.encodeULeb128(arrLen);
        int lenLen = arrLenByte.length;
        byte[][] targetByte = new byte[arrLen][];
        int allLen = lenLen;
        for (int i = 0; i < arrLen; ++i) {
            targetByte[i] = ParamsStream.packString(target[i]);
            allLen += targetByte[i].length;
        }
        byte[] retByte = new byte[allLen];
        System.arraycopy(arrLenByte, 0, retByte, 0, lenLen);
        int pos = lenLen;
        for (int i = 0; i < arrLen; ++i) {
            System.arraycopy(targetByte[i], 0, retByte, pos, targetByte[i].length);
            pos += targetByte[i].length;
        }
        return retByte;
    }

    public static byte[] packHexStringArray(String[] target) throws HexException {
        if (target == null) {
            throw new NullPointerException();
        }
        int arrLen = target.length;
        byte[] arrLenByte = ParamsStream.encodeULeb128(arrLen);
        int lenLen = arrLenByte.length;
        byte[][] targetByte = new byte[arrLen][];
        int allLen = lenLen;
        for (int i = 0; i < arrLen; ++i) {
            targetByte[i] = ParamsStream.packHexString(target[i]);
            allLen += targetByte[i].length;
        }
        byte[] retByte = new byte[allLen];
        System.arraycopy(arrLenByte, 0, retByte, 0, lenLen);
        int pos = lenLen;
        for (int i = 0; i < arrLen; ++i) {
            System.arraycopy(targetByte[i], 0, retByte, pos, targetByte[i].length);
            pos += targetByte[i].length;
        }
        return retByte;
    }

    public static byte[] packByteArray(byte[] target) {
        if (target == null) {
            throw new NullPointerException();
        }
        int arrLen = target.length;
        byte[] arrLenByte = ParamsStream.encodeULeb128(arrLen);
        int lenLen = arrLenByte.length;
        byte[] targetByte = new byte[lenLen + arrLen];
        System.arraycopy(arrLenByte, 0, targetByte, 0, lenLen);
        for (int i = 0; i < arrLen; ++i) {
            targetByte[lenLen + i] = target[i];
        }
        return targetByte;
    }

    public static byte[] packCharArray(char[] target) {
        if (target == null) {
            throw new NullPointerException();
        }
        int arrLen = target.length;
        byte[] arrLenByte = ParamsStream.encodeULeb128(arrLen);
        int lenLen = arrLenByte.length;
        byte[] targetByte = new byte[lenLen + arrLen];
        System.arraycopy(arrLenByte, 0, targetByte, 0, lenLen);
        for (int i = 0; i < arrLen; ++i) {
            targetByte[lenLen + i] = (byte)target[i];
        }
        return targetByte;
    }

    public static byte[] packBooleanArray(boolean[] target) {
        if (target == null) {
            throw new NullPointerException();
        }
        int arrLen = target.length;
        byte[] arrLenByte = ParamsStream.encodeULeb128(arrLen);
        int lenLen = arrLenByte.length;
        byte[] targetByte = new byte[lenLen + arrLen];
        System.arraycopy(arrLenByte, 0, targetByte, 0, lenLen);
        for (int i = 0; i < arrLen; ++i) {
            targetByte[lenLen + i] = target[i] ? (byte)1 : 0;
        }
        return targetByte;
    }

    public static byte[] packIdentity(Identity target) {
        if (target == null) {
            throw new NullPointerException();
        }
        byte[] idBytes = target.getData();
        int valueLen = idBytes.length;
        byte[] lenByte = ParamsStream.encodeULeb128(valueLen);
        int lenLen = lenByte.length;
        byte[] targetByte = new byte[lenLen + valueLen];
        System.arraycopy(lenByte, 0, targetByte, 0, lenLen);
        System.arraycopy(idBytes, 0, targetByte, lenLen, valueLen);
        return targetByte;
    }

    public static byte[] packIdentityArray(Identity[] target) {
        if (target == null) {
            throw new NullPointerException();
        }
        int arrLen = target.length;
        byte[] arrLenByte = ParamsStream.encodeULeb128(arrLen);
        int lenLen = arrLenByte.length;
        byte[][] targetByte = new byte[arrLen][];
        int allLen = lenLen;
        for (int i = 0; i < arrLen; ++i) {
            targetByte[i] = ParamsStream.packIdentity(target[i]);
            allLen += targetByte[i].length;
        }
        byte[] retByte = new byte[allLen];
        System.arraycopy(arrLenByte, 0, retByte, 0, lenLen);
        int pos = lenLen;
        for (int i = 0; i < arrLen; ++i) {
            System.arraycopy(targetByte[i], 0, retByte, pos, targetByte[i].length);
            pos += targetByte[i].length;
        }
        return retByte;
    }

    public static <T> byte[] packVarargs(T ... args) {
        int arrLen = args.length;
        byte[][] targetByte = new byte[arrLen][];
        int allLen = 0;
        int index = 0;
        for (T t : args) {
            try {
                targetByte[index] = MychainLib.pack(t);
            }
            catch (Exception e) {
                MychainLib.revertString(e.getMessage());
            }
            allLen += targetByte[index].length;
            ++index;
        }
        byte[] retByte = new byte[allLen];
        int pos = 0;
        for (int i = 0; i < arrLen; ++i) {
            System.arraycopy(targetByte[i], 0, retByte, pos, targetByte[i].length);
            pos += targetByte[i].length;
        }
        return retByte;
    }

    public static byte[] pack2DByteArray(byte[][] target) {
        int arrLen2DByteLen;
        if (target == null) {
            throw new NullPointerException();
        }
        int arrLen2D = target.length;
        byte[] arrLen2DByte = ParamsStream.encodeULeb128(arrLen2D);
        int allLen = arrLen2DByteLen = arrLen2DByte.length;
        byte[][] targetByte = new byte[arrLen2D][];
        for (int i = 0; i < arrLen2D; ++i) {
            targetByte[i] = ParamsStream.packByteArray(target[i]);
            allLen += targetByte[i].length;
        }
        byte[] retByte = new byte[allLen];
        System.arraycopy(arrLen2DByte, 0, retByte, 0, arrLen2DByteLen);
        int pos = arrLen2DByteLen;
        for (int i = 0; i < arrLen2D; ++i) {
            System.arraycopy(targetByte[i], 0, retByte, pos, targetByte[i].length);
            pos += targetByte[i].length;
        }
        return retByte;
    }

    public byte[][] read2DByteArray() {
        int len = this.decodeULeb128();
        if (len == -1 || len == 0) {
            return new byte[0][0];
        }
        byte[][] retByte = new byte[len][];
        for (int i = 0; i < len; ++i) {
            retByte[i] = this.readByteArray();
        }
        return retByte;
    }

    public static byte[] packPair(MychainLib.Pair target) {
        if (target == null) {
            throw new NullPointerException();
        }
        byte[] idBytes = ParamsStream.packByteArray(target.id);
        byte[] aclBytes = ParamsStream.packByte(target.acl);
        byte[] ret = new byte[idBytes.length + aclBytes.length];
        System.arraycopy(idBytes, 0, ret, 0, idBytes.length);
        System.arraycopy(aclBytes, 0, ret, idBytes.length, aclBytes.length);
        return ret;
    }

    public MychainLib.Pair readPair() {
        byte[] id = this.readByteArray();
        byte acl = this.readByte();
        return new MychainLib.Pair(id, acl);
    }

    public static byte[] packPairInArray(MychainLib.Pair[] target) {
        if (target == null) {
            throw new NullPointerException();
        }
        int arrLen = target.length;
        byte[] arrLenByte = ParamsStream.encodeULeb128(arrLen);
        int lenLen = arrLenByte.length;
        byte[][] targetByte = new byte[arrLen][];
        int allLen = lenLen;
        for (int i = 0; i < arrLen; ++i) {
            targetByte[i] = ParamsStream.packPair(target[i]);
            allLen += targetByte[i].length;
        }
        byte[] retByte = new byte[allLen];
        System.arraycopy(arrLenByte, 0, retByte, 0, lenLen);
        int pos = lenLen;
        for (int i = 0; i < arrLen; ++i) {
            System.arraycopy(targetByte[i], 0, retByte, pos, targetByte[i].length);
            pos += targetByte[i].length;
        }
        return retByte;
    }

    public MychainLib.Pair[] readPairInArray() {
        int len = this.decodeULeb128();
        if (len == -1 || len == 0) {
            return new MychainLib.Pair[0];
        }
        MychainLib.Pair[] retArr = new MychainLib.Pair[len];
        for (int i = 0; i < len; ++i) {
            retArr[i] = this.readPair();
        }
        return retArr;
    }
}

