/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.runtime;

import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.interop.Export;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.interop.StaticInit;
import com.antgroup.antchain.myjava.interop.Unmanaged;
import com.antgroup.antchain.myjava.runtime.CallSite;
import com.antgroup.antchain.myjava.runtime.CallSiteLocation;
import com.antgroup.antchain.myjava.runtime.Console;
import com.antgroup.antchain.myjava.runtime.ExceptionHandler;
import com.antgroup.antchain.myjava.runtime.MethodLocation;
import com.antgroup.antchain.myjava.runtime.MychainLib;
import com.antgroup.antchain.myjava.runtime.RuntimeClass;
import com.antgroup.antchain.myjava.runtime.RuntimeObject;
import com.antgroup.antchain.myjava.runtime.ShadowStack;

@StaticInit
@NoMetadata
public final class ExceptionHandling {
    private static Throwable thrownException;

    private ExceptionHandling() {
    }

    @Unmanaged
    public static native CallSite findCallSiteById(int var0, Address var1);

    @Unmanaged
    public static native void abort();

    @Unmanaged
    public static void printStack() {
        Address stackFrame = ShadowStack.getStackTop();
        while (stackFrame != null) {
            int callSiteId = ShadowStack.getCallSiteId(stackFrame);
            CallSite callSite = ExceptionHandling.findCallSiteById(callSiteId, stackFrame);
            CallSiteLocation location = callSite.location;
            while (location != null) {
                MethodLocation methodLocation = location.method;
                if (methodLocation != null) {
                    Console.printlnString("\tat ");
                    if (methodLocation.className == null || methodLocation.methodName == null) {
                        Console.printlnString("(Unknown method)");
                    } else {
                        Console.printlnString(methodLocation.className.value);
                        Console.printlnString(".");
                        Console.printlnString(methodLocation.methodName.value);
                    }
                    Console.printlnString("(");
                    if (methodLocation.fileName != null && location.lineNumber >= 0) {
                        Console.printlnString(methodLocation.fileName.value);
                        Console.printlnString(":");
                    }
                    Console.printlnString(")\n");
                }
                location = location.next;
            }
            stackFrame = ShadowStack.getNextStackFrame(stackFrame);
        }
    }

    @Export(name="myjava_catchException")
    @Unmanaged
    public static Throwable catchException() {
        Throwable exception = thrownException;
        thrownException = null;
        return exception;
    }

    @Unmanaged
    public static void throwException(Throwable exception) {
        int callSiteId;
        thrownException = exception;
        RuntimeObject exceptionPtr = (RuntimeObject)Address.ofObject(exception).toStructure();
        RuntimeClass exceptionClass = RuntimeClass.getClass(exceptionPtr);
        Address stackFrame = ShadowStack.getStackTop();
        int handlerId = 0;
        block0: while (stackFrame != null) {
            callSiteId = ShadowStack.getCallSiteId(stackFrame);
            if (callSiteId >= 0) {
                CallSite callSite = ExceptionHandling.findCallSiteById(callSiteId, stackFrame);
                ExceptionHandler handler = callSite.firstHandler;
                while (handler != null) {
                    if (handler.exceptionClass == null || handler.exceptionClass.isSupertypeOf.apply(exceptionClass)) {
                        handlerId = handler.id;
                        ShadowStack.setExceptionHandlerId(stackFrame, handlerId);
                        break block0;
                    }
                    handler = handler.next;
                }
                ShadowStack.setExceptionHandlerId(stackFrame, callSiteId - 1);
            }
            stackFrame = ShadowStack.getNextStackFrame(stackFrame);
        }
        if (stackFrame == null) {
            stackFrame = ShadowStack.getStackTop();
            while (stackFrame != null) {
                callSiteId = ShadowStack.getCallSiteId(stackFrame);
                if (callSiteId >= 0) {
                    ShadowStack.setExceptionHandlerId(stackFrame, callSiteId + 1);
                }
                stackFrame = ShadowStack.getNextStackFrame(stackFrame);
            }
            ExceptionHandling.printStack();
            String msg = exception.getMessage();
            if (msg != null) {
                MychainLib.revertString(msg);
            } else {
                MychainLib.revertString(exception.getClass().getName());
            }
        }
    }

    @Unmanaged
    public static void throwClassCastException() {
        throw new ClassCastException();
    }

    @Unmanaged
    @Export(name="myjava_throwNullPointerException")
    public static void throwNullPointerException() {
        ExceptionHandling.throwException(new NullPointerException());
    }

    @Unmanaged
    @Export(name="myjava_throwArrayIndexOutOfBoundsException")
    public static void throwArrayIndexOutOfBoundsException() {
        ExceptionHandling.throwException(new ArrayIndexOutOfBoundsException());
    }

    @Unmanaged
    private static int callStackSize() {
        Address stackFrame = ShadowStack.getStackTop();
        int size = 0;
        while (stackFrame != null) {
            int callSiteId = ShadowStack.getCallSiteId(stackFrame);
            if (callSiteId >= 0) {
                CallSite callSite = ExceptionHandling.findCallSiteById(callSiteId, stackFrame);
                CallSiteLocation location = callSite.location;
                if (location == null) {
                    ++size;
                } else {
                    while (location != null) {
                        ++size;
                        location = location.next;
                    }
                }
            }
            stackFrame = ShadowStack.getNextStackFrame(stackFrame);
        }
        return size;
    }

    @Unmanaged
    public static StackTraceElement[] fillStackTrace() {
        Address stackFrame = ShadowStack.getStackTop();
        int size = ExceptionHandling.callStackSize();
        ShadowStack.allocStack(1);
        ShadowStack.removeGCRoot(0);
        StackTraceElement[] target = new StackTraceElement[size];
        ShadowStack.registerGCRoot(0, target);
        int index = 0;
        while (stackFrame != null) {
            int callSiteId = ShadowStack.getCallSiteId(stackFrame);
            if (callSiteId >= 0) {
                CallSite callSite = ExceptionHandling.findCallSiteById(callSiteId, stackFrame);
                CallSiteLocation location = callSite.location;
                if (location == null) {
                    target[index++] = new StackTraceElement("", "", null, -1);
                } else {
                    while (location != null) {
                        MethodLocation methodLocation = location.method;
                        StackTraceElement element = methodLocation != null ? new StackTraceElement(methodLocation.className != null ? methodLocation.className.value : "", methodLocation.methodName != null ? methodLocation.methodName.value : "", methodLocation.fileName != null ? methodLocation.fileName.value : null, location.lineNumber) : new StackTraceElement("", "", null, location.lineNumber);
                        target[index++] = element;
                        location = location.next;
                    }
                }
            }
            stackFrame = ShadowStack.getNextStackFrame(stackFrame);
        }
        ShadowStack.releaseStack(1);
        return target;
    }
}

