/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.runtime;

import com.antgroup.antchain.myjava.runtime.Identity;
import com.antgroup.antchain.myjava.runtime.MychainLib;
import java.nio.ByteBuffer;

public class EVMOutput {
    private byte[] output;
    private int offset = 0;

    public void setOutput(byte[] output) {
        this.output = output;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public byte[] getOutput() {
        return this.output;
    }

    public int getOffset() {
        return this.offset;
    }

    public static long bytes2Long(byte[] input) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(input, 24, 8);
        buffer.flip();
        return buffer.getLong();
    }

    public long readLong() {
        if (this.offset * 32 + 32 > this.output.length) {
            MychainLib.revertString("readLong exceeds output length");
        }
        byte[] tmp = new byte[32];
        System.arraycopy(this.output, this.offset * 32, tmp, 0, 32);
        ++this.offset;
        return EVMOutput.bytes2Long(tmp);
    }

    public boolean readBool() {
        if (this.offset * 32 + 32 > this.output.length) {
            MychainLib.revertString("readBool exceeds output length");
        }
        boolean ret = this.output[this.offset * 32 + 31] != 0;
        ++this.offset;
        return ret;
    }

    public Identity readIdentity() {
        if (this.offset * 32 + 32 > this.output.length) {
            MychainLib.revertString("readIdentity exceeds output length");
        }
        byte[] tmp = new byte[32];
        System.arraycopy(this.output, this.offset * 32, tmp, 0, 32);
        ++this.offset;
        return new Identity(tmp);
    }

    public String readString() {
        if (this.offset * 32 + 32 > this.output.length) {
            MychainLib.revertString("readString exceeds output length");
        }
        byte[] tmpOffset = new byte[32];
        System.arraycopy(this.output, this.offset * 32, tmpOffset, 0, 32);
        long strOffset = EVMOutput.bytes2Long(tmpOffset);
        if (strOffset + 32L > (long)this.output.length) {
            MychainLib.revertString("readString exceeds output length");
        }
        byte[] tmpSize = new byte[32];
        System.arraycopy(this.output, (int)strOffset, tmpSize, 0, 32);
        long strSize = EVMOutput.bytes2Long(tmpSize);
        if ((int)strOffset + 32 + (int)strSize > this.output.length) {
            MychainLib.revertString("readString exceeds output length");
        }
        byte[] tmp = new byte[(int)strSize];
        System.arraycopy(this.output, (int)strOffset + 32, tmp, 0, (int)strSize);
        ++this.offset;
        return new String(tmp);
    }

    public byte[] readBytes() {
        if (this.offset * 32 + 32 > this.output.length) {
            MychainLib.revertString("readBytes exceeds output length");
        }
        byte[] tmpOffset = new byte[32];
        System.arraycopy(this.output, this.offset * 32, tmpOffset, 0, 32);
        long strOffset = EVMOutput.bytes2Long(tmpOffset);
        if (strOffset + 32L > (long)this.output.length) {
            MychainLib.revertString("readBytes exceeds output length");
        }
        byte[] tmpSize = new byte[32];
        System.arraycopy(this.output, (int)strOffset, tmpSize, 0, 32);
        long strSize = EVMOutput.bytes2Long(tmpSize);
        if ((int)strOffset + 32 + (int)strSize > this.output.length) {
            MychainLib.revertString("readBytes exceeds output length");
        }
        byte[] tmp = new byte[(int)strSize];
        System.arraycopy(this.output, (int)strOffset + 32, tmp, 0, (int)strSize);
        ++this.offset;
        return tmp;
    }

    public byte[] readBytesN() {
        if (this.offset * 32 + 32 > this.output.length) {
            MychainLib.revertString("readBytes exceeds output length");
        }
        byte[] tmp = new byte[32];
        System.arraycopy(this.output, this.offset * 32, tmp, 0, 32);
        ++this.offset;
        return tmp;
    }

    public long[] readLongArray() {
        if (this.offset * 32 + 32 > this.output.length) {
            MychainLib.revertString("readLongArray exceeds output length");
        }
        byte[] tmpOffset = new byte[32];
        System.arraycopy(this.output, this.offset * 32, tmpOffset, 0, 32);
        long strOffset = EVMOutput.bytes2Long(tmpOffset);
        if (strOffset + 32L > (long)this.output.length) {
            MychainLib.revertString("readLongArray exceeds output length");
        }
        byte[] tmpSize = new byte[32];
        System.arraycopy(this.output, (int)strOffset, tmpSize, 0, 32);
        long strSize = EVMOutput.bytes2Long(tmpSize);
        long[] ret = new long[(int)strSize];
        for (int i = 0; i < (int)strSize; ++i) {
            long value;
            if ((int)strOffset + (i + 1) * 32 + 32 > this.output.length) {
                MychainLib.revertString("readLongArray exceeds output length");
            }
            byte[] valueBytes = new byte[32];
            System.arraycopy(this.output, (int)strOffset + (i + 1) * 32, valueBytes, 0, 32);
            ret[i] = value = EVMOutput.bytes2Long(valueBytes);
        }
        ++this.offset;
        return ret;
    }

    public boolean[] readBoolArray() {
        if (this.offset * 32 + 32 > this.output.length) {
            MychainLib.revertString("readBoolArray exceeds output length");
        }
        byte[] tmpOffset = new byte[32];
        System.arraycopy(this.output, this.offset * 32, tmpOffset, 0, 32);
        long strOffset = EVMOutput.bytes2Long(tmpOffset);
        if (strOffset + 32L > (long)this.output.length) {
            MychainLib.revertString("readBoolArray exceeds output length");
        }
        byte[] tmpSize = new byte[32];
        System.arraycopy(this.output, (int)strOffset, tmpSize, 0, 32);
        long strSize = EVMOutput.bytes2Long(tmpSize);
        boolean[] ret = new boolean[(int)strSize];
        for (int i = 0; i < (int)strSize; ++i) {
            if ((int)strOffset + (i + 1) * 32 + 32 > this.output.length) {
                MychainLib.revertString("readBoolArray exceeds output length");
            }
            byte[] valueBytes = new byte[32];
            System.arraycopy(this.output, (int)strOffset + (i + 1) * 32, valueBytes, 0, 32);
            long value = EVMOutput.bytes2Long(valueBytes);
            ret[i] = value != 0L;
        }
        ++this.offset;
        return ret;
    }

    public byte[][] readBytesNArray() {
        if (this.offset * 32 + 32 > this.output.length) {
            MychainLib.revertString("readBytesNArray exceeds output length");
        }
        byte[] tmpOffset = new byte[32];
        System.arraycopy(this.output, this.offset * 32, tmpOffset, 0, 32);
        long strOffset = EVMOutput.bytes2Long(tmpOffset);
        if (strOffset + 32L > (long)this.output.length) {
            MychainLib.revertString("readBytesNArray exceeds output length");
        }
        byte[] tmpSize = new byte[32];
        System.arraycopy(this.output, (int)strOffset, tmpSize, 0, 32);
        long strSize = EVMOutput.bytes2Long(tmpSize);
        byte[][] ret = new byte[(int)strSize][];
        for (int i = 0; i < (int)strSize; ++i) {
            if ((int)strOffset + (i + 1) * 32 + 32 > this.output.length) {
                MychainLib.revertString("readBytesNArray exceeds output length");
            }
            byte[] valueBytes = new byte[32];
            System.arraycopy(this.output, (int)strOffset + (i + 1) * 32, valueBytes, 0, 32);
            ret[i] = valueBytes;
        }
        ++this.offset;
        return ret;
    }
}

