/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.runtime;

import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.interop.NoMetadata;
import com.antgroup.antchain.myjava.interop.StaticInit;
import com.antgroup.antchain.myjava.interop.Structure;
import com.antgroup.antchain.myjava.interop.Unmanaged;
import com.antgroup.antchain.myjava.runtime.GC;
import com.antgroup.antchain.myjava.runtime.RuntimeArray;
import com.antgroup.antchain.myjava.runtime.RuntimeClass;
import com.antgroup.antchain.myjava.runtime.RuntimeObject;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;

@StaticInit
@Unmanaged
@NoMetadata
public final class Allocator {
    private Allocator() {
    }

    public static Address allocate(RuntimeClass tag) {
        RuntimeObject object = GC.alloc(tag.size);
        Allocator.fillZero(object.toAddress(), tag.size);
        object.classReference = tag.pack();
        return object.toAddress();
    }

    public static Address allocateArray(RuntimeClass tag, int size) {
        int itemSize;
        int n = itemSize = (tag.itemType.flags & 2) != 0 ? tag.itemType.size : Address.sizeOf();
        if (itemSize == 0) {
            WasmRuntime.abortDirectly();
            return null;
        }
        int sizeInBytes = Address.align(Address.fromInt(Structure.sizeOf(RuntimeArray.class)), itemSize).toInt();
        sizeInBytes += itemSize * size;
        sizeInBytes = Address.align(Address.fromInt(sizeInBytes), Address.sizeOf()).toInt();
        Address result = GC.alloc(sizeInBytes).toAddress();
        Allocator.fillZero(result, sizeInBytes);
        RuntimeArray array = (RuntimeArray)result.toStructure();
        array.classReference = tag.pack();
        array.size = size;
        return result;
    }

    public static RuntimeArray allocateMultiArray(RuntimeClass tag, Address dimensions, int dimensionCount) {
        int size = dimensions.getInt();
        RuntimeArray array = (RuntimeArray)Allocator.allocateArray(tag, dimensions.getInt()).toStructure();
        if (dimensionCount > 1) {
            Address arrayData = Structure.add(RuntimeArray.class, array, 1).toAddress();
            arrayData = Address.align(arrayData, Address.sizeOf());
            for (int i = 0; i < size; ++i) {
                RuntimeArray innerArray = Allocator.allocateMultiArray(tag.itemType, dimensions.add(4), dimensionCount - 1);
                arrayData.putAddress(innerArray.toAddress());
                arrayData = arrayData.add(Address.sizeOf());
            }
        }
        return array;
    }

    public static native void fillZero(Address var0, int var1);

    public static native void fill(Address var0, byte var1, int var2);

    public static native void moveMemoryBlock(Address var0, Address var1, int var2);

    public static native boolean isInitialized(Class<?> var0);
}

