/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.util;

import com.antgroup.antchain.myjava.common.DominatorTree;
import com.antgroup.antchain.myjava.common.Graph;
import com.antgroup.antchain.myjava.common.GraphUtils;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.util.DefinitionExtractor;
import com.antgroup.antchain.myjava.model.util.ProgramUtils;
import com.antgroup.antchain.myjava.model.util.UsageExtractor;
import java.util.BitSet;
import org.teavm.hppc.IntStack;

public class LivenessAnalyzer {
    private BitSet[] liveVars;
    private BitSet[] liveOutVars;

    public boolean liveIn(int block, int var) {
        return this.liveVars[block].get(var);
    }

    public BitSet liveIn(int block) {
        return (BitSet)this.liveVars[block].clone();
    }

    public BitSet liveOut(int block) {
        return (BitSet)this.liveOutVars[block].clone();
    }

    public void analyze(Program program, MethodDescriptor descriptor) {
        this.analyze(program, descriptor.parameterCount() + 1);
    }

    public void analyze(Program program, int parameterCount) {
        int i;
        Graph cfg = ProgramUtils.buildControlFlowGraph(program);
        DominatorTree dominatorTree = GraphUtils.buildDominatorTree(cfg);
        BitSet[] visited = new BitSet[program.basicBlockCount()];
        this.liveVars = new BitSet[program.basicBlockCount()];
        this.liveOutVars = new BitSet[program.basicBlockCount()];
        for (int i2 = 0; i2 < this.liveVars.length; ++i2) {
            visited[i2] = new BitSet(program.variableCount());
            this.liveVars[i2] = new BitSet(program.variableCount());
            this.liveOutVars[i2] = new BitSet(program.variableCount());
        }
        UsageExtractor usageExtractor = new UsageExtractor();
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        IntStack stack = new IntStack();
        int[] definitions = new int[program.variableCount()];
        for (i = 0; i < program.basicBlockCount(); ++i) {
            Object insn;
            BasicBlock block = program.basicBlockAt(i);
            BitSet usedVariables = new BitSet(program.variableCount());
            for (insn = block.getLastInstruction(); insn != null; insn = ((Instruction)insn).getPrevious()) {
                ((Instruction)insn).acceptVisitor(defExtractor);
                for (Variable var : defExtractor.getDefinedVariables()) {
                    definitions[var.getIndex()] = i;
                    usedVariables.clear(var.getIndex());
                }
                ((Instruction)insn).acceptVisitor(usageExtractor);
                for (Variable var : usageExtractor.getUsedVariables()) {
                    usedVariables.set(var.getIndex());
                }
            }
            insn = block.getPhis().iterator();
            while (insn.hasNext()) {
                Phi phi = (Phi)insn.next();
                definitions[phi.getReceiver().getIndex()] = i;
                usedVariables.clear(phi.getReceiver().getIndex());
                for (Incoming incoming : phi.getIncomings()) {
                    stack.push(incoming.getSource().getIndex());
                    stack.push(incoming.getValue().getIndex());
                }
            }
            if (block.getExceptionVariable() != null) {
                definitions[block.getExceptionVariable().getIndex()] = i;
                usedVariables.clear(block.getExceptionVariable().getIndex());
            }
            if (i == 0) {
                for (int v = 0; v < parameterCount; ++v) {
                    definitions[v] = 0;
                    usedVariables.clear(v);
                }
            }
            int[] predecessors = cfg.incomingEdges(i);
            int v = usedVariables.nextSetBit(0);
            while (v >= 0) {
                this.liveVars[i].set(v);
                for (int pred : predecessors) {
                    stack.push(pred);
                    stack.push(v);
                }
                v = usedVariables.nextSetBit(v + 1);
            }
        }
        while (!stack.isEmpty()) {
            int variable = stack.pop();
            int block = stack.pop();
            BitSet blockVisited = visited[block];
            if (blockVisited.get(variable)) continue;
            blockVisited.set(variable);
            if (definitions[variable] == block || !dominatorTree.dominates(definitions[variable], block)) continue;
            this.liveVars[block].set(variable, true);
            for (int pred : cfg.incomingEdges(block)) {
                if (visited[pred].get(variable)) continue;
                stack.push(pred);
                stack.push(variable);
            }
        }
        for (i = 0; i < this.liveVars.length; ++i) {
            for (int j : cfg.incomingEdges(i)) {
                this.liveOutVars[j].or(this.liveVars[i]);
            }
            Object block = program.basicBlockAt(i);
            for (Phi phi : ((BasicBlock)block).getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    this.liveOutVars[incoming.getSource().getIndex()].set(incoming.getValue().getIndex());
                }
            }
        }
    }
}

