/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.util;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.InvokeDynamicInstruction;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.AbstractInstructionVisitor;
import com.antgroup.antchain.myjava.model.instructions.ArrayLengthInstruction;
import com.antgroup.antchain.myjava.model.instructions.AssignInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryBranchingInstruction;
import com.antgroup.antchain.myjava.model.instructions.BinaryInstruction;
import com.antgroup.antchain.myjava.model.instructions.BoundCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.BranchingInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastIntegerInstruction;
import com.antgroup.antchain.myjava.model.instructions.CastNumberInstruction;
import com.antgroup.antchain.myjava.model.instructions.ClassConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.CloneArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructInstruction;
import com.antgroup.antchain.myjava.model.instructions.ConstructMultiArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.DoubleConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.ExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.FloatConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.IntegerConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.IsInstanceInstruction;
import com.antgroup.antchain.myjava.model.instructions.LongConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.MonitorEnterInstruction;
import com.antgroup.antchain.myjava.model.instructions.MonitorExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.NegateInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullCheckInstruction;
import com.antgroup.antchain.myjava.model.instructions.NullConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutElementInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.RaiseInstruction;
import com.antgroup.antchain.myjava.model.instructions.StringConstantInstruction;
import com.antgroup.antchain.myjava.model.instructions.SwitchInstruction;
import com.antgroup.antchain.myjava.model.instructions.UnwrapArrayInstruction;
import java.util.function.Function;

public class InstructionVariableMapper
extends AbstractInstructionVisitor {
    private final Function<Variable, Variable> f;

    public InstructionVariableMapper(Function<Variable, Variable> f) {
        this.f = f;
    }

    public void apply(BasicBlock block) {
        if (block.getExceptionVariable() != null) {
            block.setExceptionVariable(this.map(block.getExceptionVariable()));
        }
        this.applyToInstructions(block);
        this.applyToPhis(block);
    }

    public void applyToInstructions(BasicBlock block) {
        for (Instruction insn : block) {
            insn.acceptVisitor(this);
        }
    }

    public void applyToPhis(BasicBlock block) {
        for (Phi phi : block.getPhis()) {
            phi.setReceiver(this.map(phi.getReceiver()));
            for (Incoming incoming : phi.getIncomings()) {
                incoming.setValue(this.map(incoming.getValue()));
            }
        }
    }

    public Variable map(Variable var) {
        return this.f.apply(var);
    }

    @Override
    public void visit(ClassConstantInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
    }

    @Override
    public void visit(NullConstantInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
    }

    @Override
    public void visit(IntegerConstantInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
    }

    @Override
    public void visit(LongConstantInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
    }

    @Override
    public void visit(FloatConstantInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
    }

    @Override
    public void visit(DoubleConstantInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
    }

    @Override
    public void visit(StringConstantInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
    }

    @Override
    public void visit(BinaryInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
        insn.setFirstOperand(this.map(insn.getFirstOperand()));
        insn.setSecondOperand(this.map(insn.getSecondOperand()));
    }

    @Override
    public void visit(NegateInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
        insn.setOperand(this.map(insn.getOperand()));
    }

    @Override
    public void visit(AssignInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
        insn.setAssignee(this.map(insn.getAssignee()));
    }

    @Override
    public void visit(CastInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
        insn.setValue(this.map(insn.getValue()));
    }

    @Override
    public void visit(CastNumberInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
        insn.setValue(this.map(insn.getValue()));
    }

    @Override
    public void visit(CastIntegerInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
        insn.setValue(this.map(insn.getValue()));
    }

    @Override
    public void visit(BranchingInstruction insn) {
        insn.setOperand(this.map(insn.getOperand()));
    }

    @Override
    public void visit(BinaryBranchingInstruction insn) {
        insn.setFirstOperand(this.map(insn.getFirstOperand()));
        insn.setSecondOperand(this.map(insn.getSecondOperand()));
    }

    @Override
    public void visit(SwitchInstruction insn) {
        insn.setCondition(this.map(insn.getCondition()));
    }

    @Override
    public void visit(ExitInstruction insn) {
        if (insn.getValueToReturn() != null) {
            insn.setValueToReturn(this.map(insn.getValueToReturn()));
        }
    }

    @Override
    public void visit(RaiseInstruction insn) {
        insn.setException(this.map(insn.getException()));
    }

    @Override
    public void visit(ConstructArrayInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
        insn.setSize(this.map(insn.getSize()));
    }

    @Override
    public void visit(ConstructInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
    }

    @Override
    public void visit(ConstructMultiArrayInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
        for (int i = 0; i < insn.getDimensions().size(); ++i) {
            insn.getDimensions().set(i, this.map(insn.getDimensions().get(i)));
        }
    }

    @Override
    public void visit(GetFieldInstruction insn) {
        if (insn.getInstance() != null) {
            insn.setInstance(this.map(insn.getInstance()));
        }
        insn.setReceiver(this.map(insn.getReceiver()));
    }

    @Override
    public void visit(PutFieldInstruction insn) {
        if (insn.getInstance() != null) {
            insn.setInstance(this.map(insn.getInstance()));
        }
        insn.setValue(this.map(insn.getValue()));
    }

    @Override
    public void visit(ArrayLengthInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
        insn.setArray(this.map(insn.getArray()));
    }

    @Override
    public void visit(CloneArrayInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
        insn.setArray(this.map(insn.getArray()));
    }

    @Override
    public void visit(UnwrapArrayInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
        insn.setArray(this.map(insn.getArray()));
    }

    @Override
    public void visit(GetElementInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
        insn.setArray(this.map(insn.getArray()));
        insn.setIndex(this.map(insn.getIndex()));
    }

    @Override
    public void visit(PutElementInstruction insn) {
        insn.setValue(this.map(insn.getValue()));
        insn.setArray(this.map(insn.getArray()));
        insn.setIndex(this.map(insn.getIndex()));
    }

    @Override
    public void visit(InvokeInstruction insn) {
        if (insn.getReceiver() != null) {
            insn.setReceiver(this.map(insn.getReceiver()));
        }
        if (insn.getInstance() != null) {
            insn.setInstance(this.map(insn.getInstance()));
        }
        insn.replaceArguments(this::map);
    }

    @Override
    public void visit(InvokeDynamicInstruction insn) {
        if (insn.getReceiver() != null) {
            insn.setReceiver(this.map(insn.getReceiver()));
        }
        if (insn.getInstance() != null) {
            insn.setInstance(this.map(insn.getInstance()));
        }
        for (int i = 0; i < insn.getArguments().size(); ++i) {
            insn.getArguments().set(i, this.map(insn.getArguments().get(i)));
        }
    }

    @Override
    public void visit(IsInstanceInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
        insn.setValue(this.map(insn.getValue()));
    }

    @Override
    public void visit(NullCheckInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
        insn.setValue(this.map(insn.getValue()));
    }

    @Override
    public void visit(MonitorEnterInstruction insn) {
        insn.setObjectRef(this.map(insn.getObjectRef()));
    }

    @Override
    public void visit(MonitorExitInstruction insn) {
        insn.setObjectRef(this.map(insn.getObjectRef()));
    }

    @Override
    public void visit(BoundCheckInstruction insn) {
        insn.setReceiver(this.map(insn.getReceiver()));
        insn.setIndex(this.map(insn.getIndex()));
        if (insn.getArray() != null) {
            insn.setArray(this.map(insn.getArray()));
        }
    }
}

