/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.transformation;

import com.antgroup.antchain.myjava.interop.NoInitClass;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.analysis.ClassInitializerInfo;
import com.antgroup.antchain.myjava.model.instructions.EmptyInstruction;
import com.antgroup.antchain.myjava.model.instructions.ExitInstruction;
import com.antgroup.antchain.myjava.model.instructions.InitClassInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.JumpInstruction;

public class ClassInitializerInsertionTransformer {
    private static final MethodDescriptor clinitDescriptor = new MethodDescriptor("<clinit>", Void.TYPE);
    private ClassReaderSource classes;
    private ClassInitializerInfo classInitializerInfo;

    public ClassInitializerInsertionTransformer(ClassReaderSource classes, ClassInitializerInfo classInitializerInfo) {
        this.classes = classes;
        this.classInitializerInfo = classInitializerInfo;
    }

    public void apply(MethodReader method, Program program) {
        boolean hasClinit;
        if (program.basicBlockCount() == 0) {
            return;
        }
        ClassReader cls = this.classes.get(method.getOwnerName());
        boolean bl = hasClinit = cls.getMethod(clinitDescriptor) != null && this.classInitializerInfo.isDynamicInitializer(cls.getName());
        if (hasClinit && ClassInitializerInsertionTransformer.needsClinitCall(method, program)) {
            BasicBlock entryBlock = program.basicBlockAt(0);
            InitClassInstruction initInsn = new InitClassInstruction();
            initInsn.setClassName(method.getOwnerName());
            entryBlock.addFirst(initInsn);
        }
    }

    private static boolean isSingleStaticInvokeMethod(MethodReader method, Program program) {
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock bb = program.basicBlockAt(i);
            for (Instruction inst : bb) {
                InvokeInstruction invokeInstruction;
                if (inst instanceof EmptyInstruction || inst instanceof JumpInstruction || inst instanceof ExitInstruction || inst instanceof InvokeInstruction && (invokeInstruction = (InvokeInstruction)inst).getType() == InvocationType.SPECIAL) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean needsClinitCall(MethodReader method, Program program) {
        if (method.getName().equals("<clinit>")) {
            return false;
        }
        if (method.getName().equals("<init>")) {
            return true;
        }
        if (method.getAnnotations().get(NoInitClass.class.getName()) != null) {
            return false;
        }
        if (program != null && ClassInitializerInsertionTransformer.isSingleStaticInvokeMethod(method, program)) {
            return false;
        }
        return method.hasModifier(ElementModifier.STATIC);
    }
}

