/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.optimization;

import com.antgroup.antchain.myjava.common.IntegerStack;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Incoming;
import com.antgroup.antchain.myjava.model.Phi;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.TryCatchBlock;
import com.antgroup.antchain.myjava.model.util.TransitionExtractor;
import java.util.List;

public class UnreachableBasicBlockEliminator {
    public void optimize(Program program) {
        BasicBlock block;
        int i;
        if (program.basicBlockCount() == 0) {
            return;
        }
        TransitionExtractor transitionExtractor = new TransitionExtractor();
        boolean[] reachable = new boolean[program.basicBlockCount()];
        IntegerStack stack = new IntegerStack(program.basicBlockCount());
        stack.push(0);
        while (!stack.isEmpty()) {
            i = stack.pop();
            if (reachable[i]) continue;
            reachable[i] = true;
            block = program.basicBlockAt(i);
            block.getLastInstruction().acceptVisitor(transitionExtractor);
            for (BasicBlock basicBlock : transitionExtractor.getTargets()) {
                if (reachable[basicBlock.getIndex()]) continue;
                stack.push(basicBlock.getIndex());
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                stack.push(tryCatch.getHandler().getIndex());
            }
        }
        for (i = 0; i < reachable.length; ++i) {
            if (reachable[i]) continue;
            block = program.basicBlockAt(i);
            if (block.getLastInstruction() != null) {
                block.getLastInstruction().acceptVisitor(transitionExtractor);
                for (BasicBlock basicBlock : transitionExtractor.getTargets()) {
                    basicBlock.removeIncomingsFrom(block);
                }
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                tryCatch.getHandler().removeIncomingsFrom(block);
            }
            program.deleteBasicBlock(i);
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            block = program.basicBlockAt(i);
            if (block == null) continue;
            for (Phi phi : block.getPhis()) {
                List<Incoming> incomingList = phi.getIncomings();
                for (int j = 0; j < incomingList.size(); ++j) {
                    Incoming incoming = incomingList.get(j);
                    if (reachable[incoming.getSource().getIndex()]) continue;
                    incomingList.remove(j--);
                }
            }
        }
        program.pack();
    }
}

