/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.optimization;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.instructions.JumpInstruction;
import com.antgroup.antchain.myjava.model.optimization.MethodOptimization;
import com.antgroup.antchain.myjava.model.optimization.MethodOptimizationContext;
import com.antgroup.antchain.myjava.model.util.BasicBlockMapper;

public class EmptyBlockElimination
implements MethodOptimization {
    @Override
    public boolean optimize(MethodOptimizationContext context, Program program) {
        int i;
        boolean affected = true;
        int[] blockMapping = new int[program.basicBlockCount()];
        for (int i2 = 0; i2 < blockMapping.length; ++i2) {
            blockMapping[i2] = i2;
        }
        int lastNonEmpty = program.basicBlockCount() - 1;
        for (i = program.basicBlockCount() - 2; i > 0; --i) {
            JumpInstruction insn;
            BasicBlock block2 = program.basicBlockAt(i);
            if (block2.getPhis().isEmpty() && block2.instructionCount() == 1 && block2.getLastInstruction() instanceof JumpInstruction && (insn = (JumpInstruction)block2.getLastInstruction()).getTarget().getIndex() == i + 1) {
                blockMapping[i] = lastNonEmpty;
            }
            lastNonEmpty = blockMapping[i];
        }
        new BasicBlockMapper(block -> blockMapping[block]).transform(program);
        for (i = 0; i < program.basicBlockCount(); ++i) {
            if (blockMapping[i] == i) continue;
            program.deleteBasicBlock(i);
            affected = true;
        }
        program.pack();
        return affected;
    }
}

