/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model.optimization;

import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.UnwrapArrayInstruction;
import com.antgroup.antchain.myjava.model.optimization.MethodOptimization;
import com.antgroup.antchain.myjava.model.optimization.MethodOptimizationContext;
import com.antgroup.antchain.myjava.model.util.DefinitionExtractor;

public class ArrayUnwrapMotion
implements MethodOptimization {
    @Override
    public boolean optimize(MethodOptimizationContext context, Program program) {
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            this.optimize(program.basicBlockAt(i));
        }
        return false;
    }

    private void optimize(BasicBlock block) {
        for (Instruction insn : block) {
            if (!(insn instanceof UnwrapArrayInstruction)) continue;
            UnwrapArrayInstruction unwrap = (UnwrapArrayInstruction)insn;
            Instruction def = this.whereDefined(insn, unwrap.getArray());
            insn.delete();
            if (def == null) {
                block.addFirst(unwrap);
                continue;
            }
            def.insertNext(unwrap);
            unwrap.setLocation(def.getLocation());
        }
    }

    private Instruction whereDefined(Instruction instruction, Variable var) {
        DefinitionExtractor def = new DefinitionExtractor();
        while (instruction != null) {
            instruction.acceptVisitor(def);
            for (Variable defVar : def.getDefinedVariables()) {
                if (defVar != var) continue;
                return instruction;
            }
            instruction = instruction.getPrevious();
        }
        return instruction;
    }
}

