/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model;

import com.antgroup.antchain.myjava.model.AnnotationContainer;
import com.antgroup.antchain.myjava.model.AnnotationValue;
import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.GenericTypeParameter;
import com.antgroup.antchain.myjava.model.GenericValueType;
import com.antgroup.antchain.myjava.model.MemberHolder;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.ReferenceCache;
import com.antgroup.antchain.myjava.model.ValueType;
import java.util.Objects;
import java.util.function.Function;

public class MethodHolder
extends MemberHolder
implements MethodReader {
    private MethodDescriptor descriptor;
    private GenericTypeParameter[] typeParameters;
    private GenericValueType genericReturnType;
    private GenericValueType[] genericParameterTypes;
    private ClassHolder owner;
    private Program program;
    private Function<MethodHolder, Program> programSupplier;
    private AnnotationValue annotationDefault;
    private AnnotationContainer[] parameterAnnotations;
    private MethodReference reference;

    public MethodHolder(MethodDescriptor descriptor) {
        super(descriptor.getName());
        this.descriptor = descriptor;
        this.parameterAnnotations = new AnnotationContainer[descriptor.parameterCount()];
        for (int i = 0; i < this.parameterAnnotations.length; ++i) {
            this.parameterAnnotations[i] = new AnnotationContainer();
        }
    }

    public MethodHolder(String name, ValueType ... signature) {
        this(new MethodDescriptor(name, signature));
    }

    @Override
    public ValueType getResultType() {
        return this.descriptor.getResultType();
    }

    @Override
    public GenericValueType getGenericResultType() {
        return this.genericReturnType;
    }

    @Override
    public int genericParameterCount() {
        return this.genericParameterTypes != null ? this.genericParameterTypes.length : 0;
    }

    @Override
    public GenericValueType genericParameterType(int index) {
        return this.genericParameterTypes != null ? this.genericParameterTypes[index] : null;
    }

    public void setGenericSignature(GenericValueType returnType, GenericValueType[] parameterTypes) {
        this.genericReturnType = Objects.requireNonNull(returnType);
        this.genericParameterTypes = (GenericValueType[])parameterTypes.clone();
    }

    public void removeGenericSignature() {
        this.genericReturnType = null;
        this.genericParameterTypes = null;
    }

    @Override
    public GenericTypeParameter[] getTypeParameters() {
        return this.typeParameters != null ? (GenericTypeParameter[])this.typeParameters.clone() : new GenericTypeParameter[]{};
    }

    public void setTypeParameters(GenericTypeParameter[] typeParameters) {
        this.typeParameters = typeParameters != null ? (GenericTypeParameter[])typeParameters.clone() : null;
    }

    @Override
    public int parameterCount() {
        return this.descriptor.parameterCount();
    }

    @Override
    public ValueType[] getSignature() {
        return this.descriptor.getSignature();
    }

    @Override
    public ValueType parameterType(int index) {
        return this.descriptor.parameterType(index);
    }

    @Override
    public ValueType[] getParameterTypes() {
        return this.descriptor.getParameterTypes();
    }

    @Override
    public AnnotationContainer parameterAnnotation(int index) {
        return this.parameterAnnotations[index];
    }

    public AnnotationContainer[] getParameterAnnotations() {
        return (AnnotationContainer[])this.parameterAnnotations.clone();
    }

    @Override
    public String getOwnerName() {
        return this.owner != null ? this.owner.getName() : null;
    }

    ClassHolder getOwner() {
        return this.owner;
    }

    void setOwner(ClassHolder owner) {
        this.reference = null;
        this.owner = owner;
    }

    @Override
    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public MethodReference getReference() {
        if (this.owner == null) {
            return null;
        }
        if (this.reference == null) {
            this.reference = new MethodReference(this.owner.getName(), this.descriptor);
        }
        return this.reference;
    }

    public void updateReference(ReferenceCache cache) {
        MethodReference reference = this.getReference();
        if (reference != null) {
            this.reference = cache.getCached(reference);
        }
    }

    @Override
    public Program getProgram() {
        if (this.program == null && this.programSupplier != null) {
            this.program = this.programSupplier.apply(this);
            this.programSupplier = null;
        }
        return this.program;
    }

    public void setProgram(Program program) {
        this.program = program;
        this.programSupplier = null;
    }

    public boolean hasProgram() {
        return this.program != null || this.programSupplier != null;
    }

    public void setProgramSupplier(Function<MethodHolder, Program> programSupplier) {
        this.program = null;
        this.programSupplier = programSupplier;
    }

    @Override
    public AnnotationValue getAnnotationDefault() {
        return this.annotationDefault;
    }

    public void setAnnotationDefault(AnnotationValue annotationDefault) {
        this.annotationDefault = annotationDefault;
    }
}

