/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.model;

import com.antgroup.antchain.myjava.model.AnnotationReader;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.ValueType;
import java.util.Collections;
import java.util.List;

public class AnnotationValue {
    public static final byte BOOLEAN = 0;
    public static final byte BYTE = 1;
    public static final byte SHORT = 2;
    public static final byte INT = 3;
    public static final byte LONG = 4;
    public static final byte FLOAT = 5;
    public static final byte DOUBLE = 6;
    public static final byte STRING = 7;
    public static final byte CLASS = 8;
    public static final byte LIST = 9;
    public static final byte ENUM = 10;
    public static final byte ANNOTATION = 11;
    public static final byte CHAR = 12;
    private byte type;
    private Object value;

    public AnnotationValue(boolean value) {
        this.type = 0;
        this.value = value;
    }

    public AnnotationValue(byte value) {
        this.type = 1;
        this.value = value;
    }

    public AnnotationValue(char value) {
        this.type = (byte)12;
        this.value = Character.valueOf(value);
    }

    public AnnotationValue(short value) {
        this.type = (byte)2;
        this.value = value;
    }

    public AnnotationValue(int value) {
        this.type = (byte)3;
        this.value = value;
    }

    public AnnotationValue(long value) {
        this.type = (byte)4;
        this.value = value;
    }

    public AnnotationValue(float value) {
        this.type = (byte)5;
        this.value = Float.valueOf(value);
    }

    public AnnotationValue(double value) {
        this.type = (byte)6;
        this.value = value;
    }

    public AnnotationValue(String value) {
        this.type = (byte)7;
        this.value = value;
    }

    public AnnotationValue(ValueType value) {
        this.type = (byte)8;
        this.value = value;
    }

    public AnnotationValue(List<AnnotationValue> value) {
        this.type = (byte)9;
        this.value = value;
    }

    public AnnotationValue(AnnotationReader value) {
        this.type = (byte)11;
        this.value = value;
    }

    public AnnotationValue(FieldReference value) {
        this.type = (byte)10;
        this.value = value;
    }

    public boolean getBoolean() {
        if (this.type != 0) {
            throw new IllegalStateException("There is no boolean value");
        }
        return (Boolean)this.value;
    }

    public char getChar() {
        if (this.type != 12) {
            throw new IllegalStateException("There is no char value");
        }
        return ((Character)this.value).charValue();
    }

    public byte getByte() {
        if (this.type != 1) {
            throw new IllegalStateException("There is no byte value");
        }
        return (Byte)this.value;
    }

    public short getShort() {
        if (this.type != 2) {
            throw new IllegalStateException("There is no short value");
        }
        return (Short)this.value;
    }

    public int getInt() {
        if (this.type != 3) {
            throw new IllegalStateException("There is no int value");
        }
        return (Integer)this.value;
    }

    public long getLong() {
        if (this.type != 4) {
            throw new IllegalStateException("There is no long value");
        }
        return (Long)this.value;
    }

    public float getFloat() {
        if (this.type != 5) {
            throw new IllegalStateException("There is no float value");
        }
        return ((Float)this.value).floatValue();
    }

    public double getDouble() {
        if (this.type != 6) {
            throw new IllegalStateException("There is no double value");
        }
        return (Double)this.value;
    }

    public String getString() {
        if (this.type != 7) {
            throw new IllegalStateException("There is no String value");
        }
        return (String)this.value;
    }

    public ValueType getJavaClass() {
        if (this.type != 8) {
            throw new IllegalStateException("There is no ValueType value");
        }
        return (ValueType)this.value;
    }

    public List<AnnotationValue> getList() {
        if (this.type != 9) {
            throw new IllegalStateException("There is no List value");
        }
        return Collections.unmodifiableList((List)this.value);
    }

    public FieldReference getEnumValue() {
        if (this.type != 10) {
            throw new IllegalStateException("There is no enum value");
        }
        return (FieldReference)this.value;
    }

    public AnnotationReader getAnnotation() {
        if (this.type != 11) {
            throw new IllegalStateException("There is no annotation value");
        }
        return (AnnotationReader)this.value;
    }

    public byte getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }
}

