/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.metaprogramming.impl;

import com.antgroup.antchain.myjava.dependency.DependencyAgent;
import com.antgroup.antchain.myjava.dependency.MethodDependency;
import com.antgroup.antchain.myjava.diagnostics.Diagnostics;
import com.antgroup.antchain.myjava.metaprogramming.CompileTime;
import com.antgroup.antchain.myjava.metaprogramming.impl.CompositeMethodGenerator;
import com.antgroup.antchain.myjava.metaprogramming.impl.MetaprogrammingClassLoader;
import com.antgroup.antchain.myjava.metaprogramming.impl.MetaprogrammingImpl;
import com.antgroup.antchain.myjava.metaprogramming.impl.TopLevelVariableContext;
import com.antgroup.antchain.myjava.metaprogramming.impl.ValueImpl;
import com.antgroup.antchain.myjava.metaprogramming.impl.model.MethodModel;
import com.antgroup.antchain.myjava.model.AccessLevel;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.CallLocation;
import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.Variable;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class UsageGenerator {
    private int suffix;
    private int ownSuffix;
    private DependencyAgent agent;
    private MethodModel model;
    private MethodDependency methodDep;
    private CallLocation location;
    private Diagnostics diagnostics;
    private Method proxyMethod;
    private MetaprogrammingClassLoader classLoader;
    private boolean annotationErrorReported;
    private MethodDependency nameDependency;

    UsageGenerator(DependencyAgent agent, MethodModel model, MethodDependency methodDep, MetaprogrammingClassLoader classLoader, int suffix) {
        this.agent = agent;
        this.diagnostics = agent.getDiagnostics();
        this.model = model;
        this.methodDep = methodDep;
        this.location = new CallLocation(methodDep.getReference());
        this.classLoader = classLoader;
        this.suffix = suffix;
    }

    void installProxyEmitter() {
        Diagnostics diagnostics = this.agent.getDiagnostics();
        try {
            this.proxyMethod = this.getJavaMethod(this.classLoader, this.model.getMetaMethod());
            this.proxyMethod.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            StringWriter stackTraceWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTraceWriter));
            diagnostics.error(this.location, "Error accessing proxy method {{m0}}: " + stackTraceWriter.getBuffer(), this.model.getMetaMethod());
            return;
        }
        this.nameDependency = this.installAdditionalDependencies();
        if (this.model.getClassParameterIndex() >= 0) {
            int index = 1 + this.model.getClassParameterIndex();
            this.methodDep.getVariable(index).getClassValueNode().addConsumer(type -> this.emitPermutation(this.findClass(type.getName())));
        } else {
            this.emitPermutation(null);
        }
    }

    private MethodDependency installAdditionalDependencies() {
        MethodDependency nameDep = this.agent.linkMethod(new MethodReference(Class.class, "getName", String.class));
        nameDep.addLocation(this.location);
        nameDep.getVariable(0).propagate(this.agent.getType(Class.class.getName()));
        nameDep.getThrown().connect(this.methodDep.getThrown());
        nameDep.use();
        MethodDependency equalsDep = this.agent.linkMethod(new MethodReference(String.class, "equals", Object.class, Boolean.TYPE));
        equalsDep.addLocation(this.location);
        nameDep.getResult().connect(equalsDep.getVariable(0));
        equalsDep.getVariable(1).propagate(this.agent.getType("java.lang.String"));
        equalsDep.getThrown().connect(this.methodDep.getThrown());
        equalsDep.use();
        MethodDependency hashCodeDep = this.agent.linkMethod(new MethodReference(String.class, "hashCode", Integer.TYPE));
        hashCodeDep.addLocation(this.location);
        hashCodeDep.getVariable(0).propagate(this.agent.getType("java.lang.String"));
        nameDep.getResult().connect(hashCodeDep.getVariable(0));
        hashCodeDep.getThrown().connect(this.methodDep.getThrown());
        hashCodeDep.use();
        this.agent.linkMethod(new MethodReference(Object.class, "hashCode", Integer.TYPE));
        this.agent.linkMethod(new MethodReference(Object.class, "equals", Object.class, Boolean.TYPE));
        return nameDep;
    }

    private void emitPermutation(ValueType type) {
        if (!this.classLoader.isCompileTimeClass(this.model.getMetaMethod().getClassName()) && !this.annotationErrorReported) {
            this.annotationErrorReported = true;
            this.diagnostics.error(this.location, "Metaprogramming method should be within class marked with {{c0}} annotation", CompileTime.class.getName());
            return;
        }
        MethodReference implRef = this.model.getUsages().get(type);
        if (implRef != null) {
            return;
        }
        String suffix = this.getSuffix();
        implRef = this.buildMethodReference(suffix);
        MetaprogrammingImpl.templateMethod = this.model.getMetaMethod();
        TopLevelVariableContext varContext = new TopLevelVariableContext(this.diagnostics);
        MetaprogrammingImpl.generator = new CompositeMethodGenerator(varContext);
        MetaprogrammingImpl.varContext = varContext;
        MetaprogrammingImpl.returnType = this.model.getMethod().getReturnType();
        MetaprogrammingImpl.generator.location = this.location != null ? this.location.getSourceLocation() : null;
        MetaprogrammingImpl.proxySuffixGenerators.clear();
        MetaprogrammingImpl.suffix = suffix;
        for (int i = 0; i <= this.model.getMetaParameterCount(); ++i) {
            MetaprogrammingImpl.generator.getProgram().createVariable();
        }
        Object[] proxyArgs = new Object[this.model.getMetaParameterCount()];
        for (int i = 0; i < proxyArgs.length; ++i) {
            proxyArgs[i] = i == this.model.getMetaClassParameterIndex() ? MetaprogrammingImpl.findClass(type) : new ValueImpl(this.getParameterVar(i), MetaprogrammingImpl.varContext, this.model.getMetaParameterType(i));
        }
        MetaprogrammingImpl.unsupportedCase = false;
        try {
            this.proxyMethod.invoke(null, proxyArgs);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.diagnostics.error(this.location, "Error calling proxy method {{m0}}: " + writer.toString(), this.model.getMetaMethod());
        }
        MetaprogrammingImpl.close();
        if (MetaprogrammingImpl.unsupportedCase) {
            return;
        }
        this.model.getUsages().put(type, implRef);
        Program program = MetaprogrammingImpl.generator.getProgram();
        ClassHolder cls = new ClassHolder(implRef.getClassName());
        cls.setLevel(AccessLevel.PUBLIC);
        cls.setParent("java.lang.Object");
        MethodHolder method = new MethodHolder(implRef.getDescriptor());
        method.setLevel(AccessLevel.PUBLIC);
        method.getModifiers().add(ElementModifier.STATIC);
        method.setProgram(program);
        cls.addMethod(method);
        this.agent.submitClass(cls);
        this.agent.getIncrementalCache().setNoCache(cls.getName());
        MethodDependency implMethod = this.agent.linkMethod(implRef);
        implMethod.addLocation(this.location);
        for (int i = 0; i < implRef.parameterCount(); ++i) {
            this.methodDep.getVariable(i + 1).connect(implMethod.getVariable(i + 1));
        }
        if (this.model.getClassParameterIndex() >= 0) {
            implMethod.getVariable(this.model.getClassParameterIndex() + 1).getClassValueNode().connect(this.nameDependency.getVariable(0));
        }
        if (implMethod.getResult() != null) {
            implMethod.getResult().connect(this.methodDep.getResult());
        }
        implMethod.getThrown().connect(this.methodDep.getThrown());
        implMethod.use();
        this.agent.linkClass(implRef.getClassName());
    }

    private ValueType findClass(String name) {
        if (name.startsWith("[")) {
            ValueType type = ValueType.parseIfPossible(name);
            if (type != null) {
                return type;
            }
            int degree = 0;
            while (name.charAt(degree) == '[') {
                ++degree;
            }
            type = ValueType.object(name.substring(degree));
            while (degree-- > 0) {
                type = ValueType.arrayOf(type);
            }
            return type;
        }
        return ValueType.object(name);
    }

    private MethodReference buildMethodReference(String suffix) {
        if (this.model.getClassParameterIndex() < 0) {
            return new MethodReference(this.model.getMethod().getClassName() + "$PROXY$" + suffix, this.model.getMethod().getDescriptor());
        }
        ValueType[] signature = new ValueType[this.model.getMetaParameterCount() + 1];
        for (int i = 0; i < signature.length - 1; ++i) {
            signature[i] = this.model.getMetaParameterType(i);
        }
        signature[i] = this.model.getMethod().getReturnType();
        return new MethodReference(this.model.getMethod().getClassName() + "$PROXY$" + suffix, this.model.getMethod().getName(), signature);
    }

    private String getSuffix() {
        return this.suffix + "_" + this.ownSuffix++;
    }

    private Method getJavaMethod(ClassLoader classLoader, MethodReference ref) throws ReflectiveOperationException {
        Class<?> cls = Class.forName(ref.getClassName(), true, classLoader);
        Class[] parameterTypes = new Class[ref.parameterCount()];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = this.getJavaType(classLoader, ref.parameterType(i));
        }
        return cls.getDeclaredMethod(ref.getName(), parameterTypes);
    }

    private Class<?> getJavaType(ClassLoader classLoader, ValueType type) throws ReflectiveOperationException {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return Boolean.TYPE;
                }
                case BYTE: {
                    return Byte.TYPE;
                }
                case SHORT: {
                    return Short.TYPE;
                }
                case CHARACTER: {
                    return Character.TYPE;
                }
                case INTEGER: {
                    return Integer.TYPE;
                }
                case LONG: {
                    return Long.TYPE;
                }
                case FLOAT: {
                    return Float.TYPE;
                }
                case DOUBLE: {
                    return Double.TYPE;
                }
            }
        } else {
            if (type instanceof ValueType.Array) {
                Class<?> componentType = this.getJavaType(classLoader, ((ValueType.Array)type).getItemType());
                return Array.newInstance(componentType, 0).getClass();
            }
            if (type instanceof ValueType.Object) {
                String className = ((ValueType.Object)type).getClassName();
                return Class.forName(className, true, classLoader);
            }
            if (type instanceof ValueType.Void) {
                return Void.TYPE;
            }
        }
        throw new AssertionError((Object)("Don't know how to map type: " + type));
    }

    private Variable getParameterVar(int index) {
        Program program = MetaprogrammingImpl.generator.getProgram();
        Variable var = program.variableAt(index + 1);
        ValueType type = this.model.getMethod().parameterType(index);
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    var = this.box(var, Boolean.class, Boolean.TYPE);
                    break;
                }
                case BYTE: {
                    var = this.box(var, Byte.class, Byte.TYPE);
                    break;
                }
                case SHORT: {
                    var = this.box(var, Short.class, Short.TYPE);
                    break;
                }
                case CHARACTER: {
                    var = this.box(var, Character.class, Character.TYPE);
                    break;
                }
                case INTEGER: {
                    var = this.box(var, Integer.class, Integer.TYPE);
                    break;
                }
                case LONG: {
                    var = this.box(var, Long.class, Long.TYPE);
                    break;
                }
                case FLOAT: {
                    var = this.box(var, Float.class, Float.TYPE);
                    break;
                }
                case DOUBLE: {
                    var = this.box(var, Double.class, Double.TYPE);
                }
            }
        }
        return var;
    }

    private Variable box(Variable var, Class<?> boxed, Class<?> primitive) {
        Program program = MetaprogrammingImpl.generator.getProgram();
        BasicBlock block = program.basicBlockAt(0);
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(new MethodReference(boxed, "valueOf", primitive, boxed));
        insn.setArguments(var);
        var = program.createVariable();
        insn.setReceiver(var);
        block.add(insn);
        return var;
    }
}

