/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.metaprogramming.impl;

import com.antgroup.antchain.myjava.metaprogramming.CompileTime;
import com.antgroup.antchain.myjava.metaprogramming.impl.MetaprogrammingInstrumentation;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.teavm.apachecommons.io.IOUtils;
import org.teavm.asm.AnnotationVisitor;
import org.teavm.asm.ClassReader;
import org.teavm.asm.ClassVisitor;
import org.teavm.asm.Type;

public class MetaprogrammingClassLoader
extends ClassLoader {
    private MetaprogrammingInstrumentation instrumentation = new MetaprogrammingInstrumentation();
    private Map<String, Boolean> compileTimeClasses = new HashMap<String, Boolean>();
    private Map<String, Boolean> compileTimePackages = new HashMap<String, Boolean>();

    public MetaprogrammingClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        block9: {
            if (!this.isCompileTimeClass(name)) {
                return super.loadClass(name, resolve);
            }
            InputStream input = this.getResourceAsStream(name.replace('.', '/') + ".class");
            try {
                byte[] array = this.instrumentation.instrument(IOUtils.toByteArray(new BufferedInputStream(input)));
                clazz = this.defineClass(name, array, 0, array.length);
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClassNotFoundException("Error reading bytecode of class " + name, e);
                }
            }
            input.close();
        }
        return clazz;
    }

    public boolean isCompileTimeClass(String name) {
        Boolean result = this.compileTimeClasses.get(name);
        if (result == null) {
            result = this.checkIfCompileTime(name);
            this.compileTimeClasses.put(name, result);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkIfCompileTime(String name) {
        CompileTimeClassVisitor visitor;
        block14: {
            int index;
            block13: {
                int index2;
                String packageName = name;
                do {
                    if ((index2 = packageName.lastIndexOf(46)) < 0) break block13;
                } while (!this.isCompileTimePackage(packageName = packageName.substring(0, index2)));
                return true;
            }
            String outerName = name;
            do {
                if ((index = outerName.lastIndexOf(36)) >= 0) continue;
                visitor = new CompileTimeClassVisitor();
                try (InputStream input = this.getResourceAsStream(name.replace('.', '/') + ".class");){
                    if (input == null) {
                        boolean bl = false;
                        return bl;
                    }
                    new ClassReader(new BufferedInputStream(input)).accept(visitor, 3);
                    break block14;
                }
                catch (IOException e) {
                    return false;
                }
            } while (!this.isCompileTimeClass(outerName = outerName.substring(0, index)));
            return true;
        }
        if (visitor.compileTime) {
            return true;
        }
        if (visitor.parent == null) return false;
        if (visitor.parent.equals(name)) return false;
        return this.isCompileTimeClass(visitor.parent);
    }

    private boolean isCompileTimePackage(String name) {
        return this.compileTimePackages.computeIfAbsent(name, n -> this.checkIfCompileTimePackage((String)n));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkIfCompileTimePackage(String name) {
        CompileTimeClassVisitor visitor = new CompileTimeClassVisitor();
        try (InputStream input = this.getResourceAsStream(name.replace('.', '/') + "/package-info.class");){
            if (input == null) {
                boolean bl = false;
                return bl;
            }
            new ClassReader(new BufferedInputStream(input)).accept(visitor, 3);
            return visitor.compileTime;
        }
        catch (IOException e) {
            return false;
        }
    }

    static class CompileTimeClassVisitor
    extends ClassVisitor {
        String parent;
        boolean compileTime;

        CompileTimeClassVisitor() {
            super(458752, null);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.parent = superName != null ? superName.replace('/', '.') : null;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals(Type.getDescriptor(CompileTime.class))) {
                this.compileTime = true;
            }
            return null;
        }
    }
}

