/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.dependency;

import com.antgroup.antchain.myjava.dependency.DependencyAnalyzer;
import com.antgroup.antchain.myjava.dependency.DependencyConsumer;
import com.antgroup.antchain.myjava.dependency.DependencyGraphBuilder;
import com.antgroup.antchain.myjava.dependency.DependencyNode;
import com.antgroup.antchain.myjava.dependency.DependencyType;
import com.antgroup.antchain.myjava.dependency.DependencyTypeFilter;
import com.antgroup.antchain.myjava.dependency.MethodDependency;
import com.antgroup.antchain.myjava.model.CallLocation;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import java.util.BitSet;

class VirtualCallConsumer
implements DependencyConsumer {
    private final DependencyNode node;
    private final MethodDescriptor methodDesc;
    private final DependencyAnalyzer analyzer;
    private final DependencyNode[] parameters;
    private final DependencyNode result;
    private final CallLocation location;
    private final BitSet knownTypes = new BitSet();
    private DependencyGraphBuilder.ExceptionConsumer exceptionConsumer;
    private DependencyTypeFilter filter;
    private boolean isPolymorphic;
    private MethodDependency monomorphicCall;

    VirtualCallConsumer(DependencyNode node, String filterClass, MethodDescriptor methodDesc, DependencyAnalyzer analyzer, DependencyNode[] parameters, DependencyNode result, CallLocation location, DependencyGraphBuilder.ExceptionConsumer exceptionConsumer) {
        this.node = node;
        this.filter = analyzer.getSuperClassFilter(filterClass);
        this.methodDesc = methodDesc;
        this.analyzer = analyzer;
        this.parameters = parameters;
        this.result = result;
        this.location = location;
        this.exceptionConsumer = exceptionConsumer;
    }

    @Override
    public void consume(DependencyType type) {
        if (!this.filter.match(type)) {
            return;
        }
        if (this.knownTypes.get(type.index)) {
            return;
        }
        this.knownTypes.set(type.index);
        String className = type.getName();
        if (className.startsWith("[")) {
            className = "java.lang.Object";
        }
        MethodDependency methodDep = this.analyzer.linkMethod(className, this.methodDesc);
        methodDep.addLocation(this.location);
        if (!methodDep.isMissing()) {
            methodDep.use(false);
            if (this.isPolymorphic) {
                methodDep.external = true;
            } else if (this.monomorphicCall == null) {
                this.monomorphicCall = methodDep;
            } else {
                this.monomorphicCall.external = true;
                this.monomorphicCall = null;
                methodDep.external = true;
                this.isPolymorphic = true;
            }
            DependencyNode[] targetParams = methodDep.getVariables();
            if (this.parameters[0] != null && targetParams[0] != null) {
                this.parameters[0].connect(targetParams[0], this.analyzer.getSuperClassFilter(methodDep.getMethod().getOwnerName()));
            }
            for (int i = 1; i < this.parameters.length; ++i) {
                if (this.parameters[i] == null || targetParams[i] == null) continue;
                this.parameters[i].connect(targetParams[i]);
            }
            if (this.result != null && methodDep.getResult() != null) {
                methodDep.getResult().connect(this.result);
            }
            methodDep.getThrown().addConsumer(this.exceptionConsumer);
        }
    }
}

