/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.dependency;

import com.antgroup.antchain.myjava.dependency.DependencyInfo;
import com.antgroup.antchain.myjava.dependency.FieldDependencyInfo;
import com.antgroup.antchain.myjava.dependency.MethodDependencyInfo;
import com.antgroup.antchain.myjava.model.AccessLevel;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.FieldHolder;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.MemberHolder;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.instructions.GetFieldInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.instructions.PutFieldInstruction;
import com.antgroup.antchain.myjava.model.transformation.ClassInitInsertion;

public class Linker {
    private DependencyInfo dependency;
    private ClassInitInsertion classInitInsertion;

    public Linker(DependencyInfo dependency) {
        this.dependency = dependency;
        this.classInitInsertion = new ClassInitInsertion(dependency);
    }

    public void link(ClassHolder cls) {
        for (MethodHolder methodHolder : cls.getMethods().toArray(new MethodHolder[0])) {
            MethodReference methodRef = methodHolder.getReference();
            MethodDependencyInfo methodDep = this.dependency.getMethod(methodRef);
            if (methodDep == null || !methodDep.isUsed()) {
                if (methodHolder.hasModifier(ElementModifier.STATIC)) {
                    cls.removeMethod(methodHolder);
                    continue;
                }
                methodHolder.getModifiers().add(ElementModifier.ABSTRACT);
                methodHolder.getModifiers().remove((Object)ElementModifier.NATIVE);
                methodHolder.setProgram(null);
                continue;
            }
            if (methodHolder.getProgram() == null) continue;
            this.link(methodHolder, methodHolder.getProgram());
        }
        for (MemberHolder memberHolder : cls.getFields().toArray(new FieldHolder[0])) {
            FieldReference fieldRef = new FieldReference(cls.getName(), memberHolder.getName());
            if (this.dependency.getField(fieldRef) != null) continue;
            cls.removeField((FieldHolder)memberHolder);
        }
    }

    public void link(MethodReader method, Program program) {
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction insn : block) {
                PutFieldInstruction putField;
                FieldDependencyInfo linkedField;
                if (insn instanceof InvokeInstruction) {
                    MethodDependencyInfo linkedMethod;
                    InvokeInstruction invoke = (InvokeInstruction)insn;
                    MethodReference calledRef = invoke.getMethod();
                    if (invoke.getType() == InvocationType.SPECIAL) {
                        linkedMethod = this.dependency.getMethodImplementation(calledRef);
                        if (linkedMethod == null) continue;
                        invoke.setMethod(linkedMethod.getReference());
                        continue;
                    }
                    if (invoke.getType() != InvocationType.VIRTUAL || (linkedMethod = this.dependency.getMethodImplementation(calledRef)) == null || linkedMethod.isMissing()) continue;
                    calledRef = linkedMethod.getReference();
                    ClassReader cls = this.dependency.getClassSource().get(calledRef.getClassName());
                    boolean isFinal = false;
                    if (cls != null) {
                        if (cls.hasModifier(ElementModifier.FINAL)) {
                            isFinal = true;
                        } else {
                            MethodReader calledMethod = cls.getMethod(calledRef.getDescriptor());
                            if (calledMethod != null && (calledMethod.hasModifier(ElementModifier.FINAL) || calledMethod.getLevel() == AccessLevel.PRIVATE)) {
                                isFinal = true;
                            }
                        }
                    }
                    if (!isFinal) continue;
                    invoke.setType(InvocationType.SPECIAL);
                    invoke.setMethod(calledRef);
                    continue;
                }
                if (insn instanceof GetFieldInstruction) {
                    GetFieldInstruction getField = (GetFieldInstruction)insn;
                    linkedField = this.dependency.getField(getField.getField());
                    if (linkedField == null) continue;
                    getField.setField(linkedField.getReference());
                    continue;
                }
                if (!(insn instanceof PutFieldInstruction) || (linkedField = this.dependency.getField((putField = (PutFieldInstruction)insn).getField())) == null) continue;
                putField.setField(linkedField.getReference());
            }
        }
        this.classInitInsertion.apply(program, method);
    }
}

