/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.dependency;

import com.antgroup.antchain.myjava.dependency.DefaultCallGraphNode;
import com.antgroup.antchain.myjava.dependency.DependencyNode;
import com.antgroup.antchain.myjava.dependency.FieldDependencyInfo;
import com.antgroup.antchain.myjava.dependency.LocationListener;
import com.antgroup.antchain.myjava.model.CallLocation;
import com.antgroup.antchain.myjava.model.FieldReader;
import com.antgroup.antchain.myjava.model.FieldReference;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class FieldDependency
implements FieldDependencyInfo {
    DependencyNode value;
    private FieldReader field;
    private boolean present;
    private FieldReference reference;
    List<LocationListener> locationListeners;
    Set<CallLocation> locations;
    boolean activated;

    FieldDependency(DependencyNode value, FieldReader field, FieldReference reference) {
        this.value = value;
        this.field = field;
        this.reference = reference;
    }

    @Override
    public DependencyNode getValue() {
        return this.value;
    }

    public FieldReader getField() {
        return this.field;
    }

    @Override
    public FieldReference getReference() {
        return this.reference;
    }

    @Override
    public boolean isMissing() {
        return this.field == null && !this.present;
    }

    public FieldDependency addLocation(CallLocation location) {
        DefaultCallGraphNode node = this.value.dependencyAnalyzer.callGraph.getNode(location.getMethod());
        if (this.locations == null) {
            this.locations = new LinkedHashSet<CallLocation>();
        }
        if (this.locations.add(location)) {
            node.addFieldAccess(this.reference, location.getSourceLocation());
            if (this.locationListeners != null) {
                for (LocationListener listener : this.locationListeners.toArray(new LocationListener[0])) {
                    listener.locationAdded(location);
                }
            }
        }
        return this;
    }

    public void addLocationListener(LocationListener listener) {
        if (this.locationListeners == null) {
            this.locationListeners = new ArrayList<LocationListener>();
            this.locationListeners.add(listener);
            if (this.locations != null) {
                for (CallLocation location : this.locations.toArray(new CallLocation[0])) {
                    listener.locationAdded(location);
                }
            }
        }
    }

    void cleanup() {
        if (this.field != null) {
            this.field = null;
            this.present = true;
        }
    }
}

