/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.dependency;

import com.antgroup.antchain.myjava.dependency.AbstractInstructionAnalyzer;
import com.antgroup.antchain.myjava.dependency.DependencyAnalyzer;
import com.antgroup.antchain.myjava.dependency.DependencyNode;
import com.antgroup.antchain.myjava.dependency.FastDependencyAnalyzer;
import com.antgroup.antchain.myjava.dependency.FastVirtualCallConsumer;
import com.antgroup.antchain.myjava.dependency.MethodDependency;
import com.antgroup.antchain.myjava.model.CallLocation;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.VariableReader;
import java.util.List;

class FastInstructionAnalyzer
extends AbstractInstructionAnalyzer {
    private FastDependencyAnalyzer dependencyAnalyzer;
    private CallLocation impreciseLocation;

    FastInstructionAnalyzer(FastDependencyAnalyzer dependencyAnalyzer) {
        this.dependencyAnalyzer = dependencyAnalyzer;
    }

    @Override
    protected void invokeSpecial(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments) {
        if (instance != null) {
            this.invokeGetClass(method);
        }
        CallLocation callLocation = this.impreciseLocation;
        if (instance == null) {
            this.dependencyAnalyzer.linkClass(method.getClassName()).initClass(callLocation);
        }
        MethodDependency methodDep = this.dependencyAnalyzer.linkMethod(method);
        methodDep.addLocation(callLocation);
        methodDep.use(false);
    }

    @Override
    protected void invokeVirtual(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments) {
        this.invokeGetClass(method);
        FastVirtualCallConsumer consumer = this.dependencyAnalyzer.getVirtualCallConsumer(method);
        consumer.addLocation(this.impreciseLocation);
    }

    private void invokeGetClass(MethodReference method) {
        if (method.getName().equals("getClass") && method.parameterCount() == 0 && method.getReturnType().isObject(Class.class)) {
            this.dependencyAnalyzer.instancesNode.connect(this.dependencyAnalyzer.classesNode);
        }
    }

    @Override
    public void cloneArray(VariableReader receiver, VariableReader array) {
        MethodDependency cloneDep = this.getAnalyzer().linkMethod(CLONE_METHOD);
        cloneDep.addLocation(this.impreciseLocation);
        cloneDep.use();
    }

    @Override
    protected DependencyNode getNode(VariableReader variable) {
        return this.dependencyAnalyzer.instancesNode;
    }

    @Override
    protected DependencyAnalyzer getAnalyzer() {
        return this.dependencyAnalyzer;
    }

    @Override
    protected CallLocation getCallLocation() {
        return this.impreciseLocation;
    }

    @Override
    public void setCaller(MethodReference caller) {
        super.setCaller(caller);
        this.impreciseLocation = new CallLocation(caller);
    }
}

